@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appautoscaling.kotlin

import com.pulumi.aws.appautoscaling.kotlin.outputs.PolicyStepScalingPolicyConfiguration
import com.pulumi.aws.appautoscaling.kotlin.outputs.PolicyTargetTrackingScalingPolicyConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.appautoscaling.kotlin.outputs.PolicyStepScalingPolicyConfiguration.Companion.toKotlin as policyStepScalingPolicyConfigurationToKotlin
import com.pulumi.aws.appautoscaling.kotlin.outputs.PolicyTargetTrackingScalingPolicyConfiguration.Companion.toKotlin as policyTargetTrackingScalingPolicyConfigurationToKotlin

/**
 * Builder for [Policy].
 */
@PulumiTagMarker
public class PolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyArgs = PolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyArgsBuilder.() -> Unit) {
        val builder = PolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Policy {
        val builtJavaResource = com.pulumi.aws.appautoscaling.Policy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Policy(builtJavaResource)
    }
}

/**
 * Provides an Application AutoScaling Policy resource.
 * ## Example Usage
 * ### DynamoDB Table Autoscaling
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appautoscaling.Target;
 * import com.pulumi.aws.appautoscaling.TargetArgs;
 * import com.pulumi.aws.appautoscaling.Policy;
 * import com.pulumi.aws.appautoscaling.PolicyArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dynamodbTableReadTarget = new Target("dynamodbTableReadTarget", TargetArgs.builder()
 *             .maxCapacity(100)
 *             .minCapacity(5)
 *             .resourceId("table/tableName")
 *             .scalableDimension("dynamodb:table:ReadCapacityUnits")
 *             .serviceNamespace("dynamodb")
 *             .build());
 *         var dynamodbTableReadPolicy = new Policy("dynamodbTableReadPolicy", PolicyArgs.builder()
 *             .policyType("TargetTrackingScaling")
 *             .resourceId(dynamodbTableReadTarget.resourceId())
 *             .scalableDimension(dynamodbTableReadTarget.scalableDimension())
 *             .serviceNamespace(dynamodbTableReadTarget.serviceNamespace())
 *             .targetTrackingScalingPolicyConfiguration(PolicyTargetTrackingScalingPolicyConfigurationArgs.builder()
 *                 .predefinedMetricSpecification(PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs.builder()
 *                     .predefinedMetricType("DynamoDBReadCapacityUtilization")
 *                     .build())
 *                 .targetValue(70)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### ECS Service Autoscaling
 * No Java example available.
 * ### Preserve desired count when updating an autoscaled ECS Service
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Service;
 * import com.pulumi.aws.ecs.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ecsService = new Service("ecsService", ServiceArgs.builder()
 *             .cluster("clusterName")
 *             .taskDefinition("taskDefinitionFamily:1")
 *             .desiredCount(2)
 *             .build());
 *     }
 * }
 * ```
 * ### Aurora Read Replica Autoscaling
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appautoscaling.Target;
 * import com.pulumi.aws.appautoscaling.TargetArgs;
 * import com.pulumi.aws.appautoscaling.Policy;
 * import com.pulumi.aws.appautoscaling.PolicyArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicasTarget = new Target("replicasTarget", TargetArgs.builder()
 *             .serviceNamespace("rds")
 *             .scalableDimension("rds:cluster:ReadReplicaCount")
 *             .resourceId(String.format("cluster:%s", aws_rds_cluster.example().id()))
 *             .minCapacity(1)
 *             .maxCapacity(15)
 *             .build());
 *         var replicasPolicy = new Policy("replicasPolicy", PolicyArgs.builder()
 *             .serviceNamespace(replicasTarget.serviceNamespace())
 *             .scalableDimension(replicasTarget.scalableDimension())
 *             .resourceId(replicasTarget.resourceId())
 *             .policyType("TargetTrackingScaling")
 *             .targetTrackingScalingPolicyConfiguration(PolicyTargetTrackingScalingPolicyConfigurationArgs.builder()
 *                 .predefinedMetricSpecification(PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs.builder()
 *                     .predefinedMetricType("RDSReaderAverageCPUUtilization")
 *                     .build())
 *                 .targetValue(75)
 *                 .scaleInCooldown(300)
 *                 .scaleOutCooldown(300)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create target tracking scaling policy using metric math
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appautoscaling.Target;
 * import com.pulumi.aws.appautoscaling.TargetArgs;
 * import com.pulumi.aws.appautoscaling.Policy;
 * import com.pulumi.aws.appautoscaling.PolicyArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ecsTarget = new Target("ecsTarget", TargetArgs.builder()
 *             .maxCapacity(4)
 *             .minCapacity(1)
 *             .resourceId("service/clusterName/serviceName")
 *             .scalableDimension("ecs:service:DesiredCount")
 *             .serviceNamespace("ecs")
 *             .build());
 *         var example = new Policy("example", PolicyArgs.builder()
 *             .policyType("TargetTrackingScaling")
 *             .resourceId(ecsTarget.resourceId())
 *             .scalableDimension(ecsTarget.scalableDimension())
 *             .serviceNamespace(ecsTarget.serviceNamespace())
 *             .targetTrackingScalingPolicyConfiguration(PolicyTargetTrackingScalingPolicyConfigurationArgs.builder()
 *                 .targetValue(100)
 *                 .customizedMetricSpecification(PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationArgs.builder()
 *                     .metrics(
 *                         PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgs.builder()
 *                             .label("Get the queue size (the number of messages waiting to be processed)")
 *                             .id("m1")
 *                             .metricStat(PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatArgs.builder()
 *                                 .metric(PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs.builder()
 *                                     .metricName("ApproximateNumberOfMessagesVisible")
 *                                     .namespace("AWS/SQS")
 *                                     .dimensions(PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs.builder()
 *                                         .name("QueueName")
 *                                         .value("my-queue")
 *                                         .build())
 *                                     .build())
 *                                 .stat("Sum")
 *                                 .build())
 *                             .returnData(false)
 *                             .build(),
 *                         PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgs.builder()
 *                             .label("Get the ECS running task count (the number of currently running tasks)")
 *                             .id("m2")
 *                             .metricStat(PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatArgs.builder()
 *                                 .metric(PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs.builder()
 *                                     .metricName("RunningTaskCount")
 *                                     .namespace("ECS/ContainerInsights")
 *                                     .dimensions(
 *                                         PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs.builder()
 *                                             .name("ClusterName")
 *                                             .value("default")
 *                                             .build(),
 *                                         PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs.builder()
 *                                             .name("ServiceName")
 *                                             .value("web-app")
 *                                             .build())
 *                                     .build())
 *                                 .stat("Average")
 *                                 .build())
 *                             .returnData(false)
 *                             .build(),
 *                         PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgs.builder()
 *                             .label("Calculate the backlog per instance")
 *                             .id("e1")
 *                             .expression("m1 / m2")
 *                             .returnData(true)
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### MSK / Kafka Autoscaling
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appautoscaling.Target;
 * import com.pulumi.aws.appautoscaling.TargetArgs;
 * import com.pulumi.aws.appautoscaling.Policy;
 * import com.pulumi.aws.appautoscaling.PolicyArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mskTarget = new Target("mskTarget", TargetArgs.builder()
 *             .serviceNamespace("kafka")
 *             .scalableDimension("kafka:broker-storage:VolumeSize")
 *             .resourceId(aws_msk_cluster.example().arn())
 *             .minCapacity(1)
 *             .maxCapacity(8)
 *             .build());
 *         var targets = new Policy("targets", PolicyArgs.builder()
 *             .serviceNamespace(mskTarget.serviceNamespace())
 *             .scalableDimension(mskTarget.scalableDimension())
 *             .resourceId(mskTarget.resourceId())
 *             .policyType("TargetTrackingScaling")
 *             .targetTrackingScalingPolicyConfiguration(PolicyTargetTrackingScalingPolicyConfigurationArgs.builder()
 *                 .predefinedMetricSpecification(PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs.builder()
 *                     .predefinedMetricType("KafkaBrokerStorageUtilization")
 *                     .build())
 *                 .targetValue(55)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Application AutoScaling Policy using the `service-namespace` , `resource-id`, `scalable-dimension` and `policy-name` separated by `/`. For example:
 * ```sh
 *  $ pulumi import aws:appautoscaling/policy:Policy test-policy service-namespace/resource-id/scalable-dimension/policy-name
 * ```
 *
 */
public class Policy internal constructor(
    override val javaResource: com.pulumi.aws.appautoscaling.Policy,
) : KotlinCustomResource(javaResource, PolicyMapper) {
    /**
     * List of CloudWatch alarm ARNs associated with the scaling policy.
     */
    public val alarmArns: Output<List<String>>
        get() = javaResource.alarmArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * ARN assigned by AWS to the scaling policy.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name of the policy. Must be between 1 and 255 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Policy type. Valid values are `StepScaling` and `TargetTrackingScaling`. Defaults to `StepScaling`. Certain services only support only one policy type. For more information see the [Target Tracking Scaling Policies](https://docs&#46;aws&#46;amazon&#46;com/autoscaling/application/userguide/application-auto-scaling-target-tracking&#46;html) and [Step Scaling Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) documentation.
     */
    public val policyType: Output<String>?
        get() = javaResource.policyType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type and unique identifier string for the resource associated with the scaling policy. Documentation can be found in the `ResourceId` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })

    /**
     * Scalable dimension of the scalable target. Documentation can be found in the `ScalableDimension` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
     */
    public val scalableDimension: Output<String>
        get() = javaResource.scalableDimension().applyValue({ args0 -> args0 })

    /**
     * AWS service namespace of the scalable target. Documentation can be found in the `ServiceNamespace` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
     */
    public val serviceNamespace: Output<String>
        get() = javaResource.serviceNamespace().applyValue({ args0 -> args0 })

    /**
     * Step scaling policy configuration, requires `policy_type = "StepScaling"` (default). See supported fields below.
     */
    public val stepScalingPolicyConfiguration: Output<PolicyStepScalingPolicyConfiguration>?
        get() = javaResource.stepScalingPolicyConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> policyStepScalingPolicyConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Target tracking policy, requires `policy_type = "TargetTrackingScaling"`. See supported fields below.
     */
    public val targetTrackingScalingPolicyConfiguration:
        Output<PolicyTargetTrackingScalingPolicyConfiguration>?
        get() = javaResource.targetTrackingScalingPolicyConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    policyTargetTrackingScalingPolicyConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object PolicyMapper : ResourceMapper<Policy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appautoscaling.Policy::class == javaResource::class

    override fun map(javaResource: Resource): Policy = Policy(
        javaResource as
            com.pulumi.aws.appautoscaling.Policy,
    )
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Policy].
 */
public suspend fun policy(name: String, block: suspend PolicyResourceBuilder.() -> Unit): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policy(name: String): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
