@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appautoscaling.kotlin

import com.pulumi.aws.appautoscaling.PolicyArgs.builder
import com.pulumi.aws.appautoscaling.kotlin.inputs.PolicyStepScalingPolicyConfigurationArgs
import com.pulumi.aws.appautoscaling.kotlin.inputs.PolicyStepScalingPolicyConfigurationArgsBuilder
import com.pulumi.aws.appautoscaling.kotlin.inputs.PolicyTargetTrackingScalingPolicyConfigurationArgs
import com.pulumi.aws.appautoscaling.kotlin.inputs.PolicyTargetTrackingScalingPolicyConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an Application AutoScaling Policy resource.
 * ## Example Usage
 * ### DynamoDB Table Autoscaling
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appautoscaling.Target;
 * import com.pulumi.aws.appautoscaling.TargetArgs;
 * import com.pulumi.aws.appautoscaling.Policy;
 * import com.pulumi.aws.appautoscaling.PolicyArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dynamodbTableReadTarget = new Target("dynamodbTableReadTarget", TargetArgs.builder()
 *             .maxCapacity(100)
 *             .minCapacity(5)
 *             .resourceId("table/tableName")
 *             .scalableDimension("dynamodb:table:ReadCapacityUnits")
 *             .serviceNamespace("dynamodb")
 *             .build());
 *         var dynamodbTableReadPolicy = new Policy("dynamodbTableReadPolicy", PolicyArgs.builder()
 *             .policyType("TargetTrackingScaling")
 *             .resourceId(dynamodbTableReadTarget.resourceId())
 *             .scalableDimension(dynamodbTableReadTarget.scalableDimension())
 *             .serviceNamespace(dynamodbTableReadTarget.serviceNamespace())
 *             .targetTrackingScalingPolicyConfiguration(PolicyTargetTrackingScalingPolicyConfigurationArgs.builder()
 *                 .predefinedMetricSpecification(PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs.builder()
 *                     .predefinedMetricType("DynamoDBReadCapacityUtilization")
 *                     .build())
 *                 .targetValue(70)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### ECS Service Autoscaling
 * No Java example available.
 * ### Preserve desired count when updating an autoscaled ECS Service
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Service;
 * import com.pulumi.aws.ecs.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ecsService = new Service("ecsService", ServiceArgs.builder()
 *             .cluster("clusterName")
 *             .taskDefinition("taskDefinitionFamily:1")
 *             .desiredCount(2)
 *             .build());
 *     }
 * }
 * ```
 * ### Aurora Read Replica Autoscaling
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appautoscaling.Target;
 * import com.pulumi.aws.appautoscaling.TargetArgs;
 * import com.pulumi.aws.appautoscaling.Policy;
 * import com.pulumi.aws.appautoscaling.PolicyArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicasTarget = new Target("replicasTarget", TargetArgs.builder()
 *             .serviceNamespace("rds")
 *             .scalableDimension("rds:cluster:ReadReplicaCount")
 *             .resourceId(String.format("cluster:%s", aws_rds_cluster.example().id()))
 *             .minCapacity(1)
 *             .maxCapacity(15)
 *             .build());
 *         var replicasPolicy = new Policy("replicasPolicy", PolicyArgs.builder()
 *             .serviceNamespace(replicasTarget.serviceNamespace())
 *             .scalableDimension(replicasTarget.scalableDimension())
 *             .resourceId(replicasTarget.resourceId())
 *             .policyType("TargetTrackingScaling")
 *             .targetTrackingScalingPolicyConfiguration(PolicyTargetTrackingScalingPolicyConfigurationArgs.builder()
 *                 .predefinedMetricSpecification(PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs.builder()
 *                     .predefinedMetricType("RDSReaderAverageCPUUtilization")
 *                     .build())
 *                 .targetValue(75)
 *                 .scaleInCooldown(300)
 *                 .scaleOutCooldown(300)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create target tracking scaling policy using metric math
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appautoscaling.Target;
 * import com.pulumi.aws.appautoscaling.TargetArgs;
 * import com.pulumi.aws.appautoscaling.Policy;
 * import com.pulumi.aws.appautoscaling.PolicyArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ecsTarget = new Target("ecsTarget", TargetArgs.builder()
 *             .maxCapacity(4)
 *             .minCapacity(1)
 *             .resourceId("service/clusterName/serviceName")
 *             .scalableDimension("ecs:service:DesiredCount")
 *             .serviceNamespace("ecs")
 *             .build());
 *         var example = new Policy("example", PolicyArgs.builder()
 *             .policyType("TargetTrackingScaling")
 *             .resourceId(ecsTarget.resourceId())
 *             .scalableDimension(ecsTarget.scalableDimension())
 *             .serviceNamespace(ecsTarget.serviceNamespace())
 *             .targetTrackingScalingPolicyConfiguration(PolicyTargetTrackingScalingPolicyConfigurationArgs.builder()
 *                 .targetValue(100)
 *                 .customizedMetricSpecification(PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationArgs.builder()
 *                     .metrics(
 *                         PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgs.builder()
 *                             .label("Get the queue size (the number of messages waiting to be processed)")
 *                             .id("m1")
 *                             .metricStat(PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatArgs.builder()
 *                                 .metric(PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs.builder()
 *                                     .metricName("ApproximateNumberOfMessagesVisible")
 *                                     .namespace("AWS/SQS")
 *                                     .dimensions(PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs.builder()
 *                                         .name("QueueName")
 *                                         .value("my-queue")
 *                                         .build())
 *                                     .build())
 *                                 .stat("Sum")
 *                                 .build())
 *                             .returnData(false)
 *                             .build(),
 *                         PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgs.builder()
 *                             .label("Get the ECS running task count (the number of currently running tasks)")
 *                             .id("m2")
 *                             .metricStat(PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatArgs.builder()
 *                                 .metric(PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs.builder()
 *                                     .metricName("RunningTaskCount")
 *                                     .namespace("ECS/ContainerInsights")
 *                                     .dimensions(
 *                                         PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs.builder()
 *                                             .name("ClusterName")
 *                                             .value("default")
 *                                             .build(),
 *                                         PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs.builder()
 *                                             .name("ServiceName")
 *                                             .value("web-app")
 *                                             .build())
 *                                     .build())
 *                                 .stat("Average")
 *                                 .build())
 *                             .returnData(false)
 *                             .build(),
 *                         PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgs.builder()
 *                             .label("Calculate the backlog per instance")
 *                             .id("e1")
 *                             .expression("m1 / m2")
 *                             .returnData(true)
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### MSK / Kafka Autoscaling
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appautoscaling.Target;
 * import com.pulumi.aws.appautoscaling.TargetArgs;
 * import com.pulumi.aws.appautoscaling.Policy;
 * import com.pulumi.aws.appautoscaling.PolicyArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mskTarget = new Target("mskTarget", TargetArgs.builder()
 *             .serviceNamespace("kafka")
 *             .scalableDimension("kafka:broker-storage:VolumeSize")
 *             .resourceId(aws_msk_cluster.example().arn())
 *             .minCapacity(1)
 *             .maxCapacity(8)
 *             .build());
 *         var targets = new Policy("targets", PolicyArgs.builder()
 *             .serviceNamespace(mskTarget.serviceNamespace())
 *             .scalableDimension(mskTarget.scalableDimension())
 *             .resourceId(mskTarget.resourceId())
 *             .policyType("TargetTrackingScaling")
 *             .targetTrackingScalingPolicyConfiguration(PolicyTargetTrackingScalingPolicyConfigurationArgs.builder()
 *                 .predefinedMetricSpecification(PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs.builder()
 *                     .predefinedMetricType("KafkaBrokerStorageUtilization")
 *                     .build())
 *                 .targetValue(55)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Application AutoScaling Policy using the `service-namespace` , `resource-id`, `scalable-dimension` and `policy-name` separated by `/`. For example:
 * ```sh
 *  $ pulumi import aws:appautoscaling/policy:Policy test-policy service-namespace/resource-id/scalable-dimension/policy-name
 * ```
 * @property name Name of the policy. Must be between 1 and 255 characters in length.
 * @property policyType Policy type. Valid values are `StepScaling` and `TargetTrackingScaling`. Defaults to `StepScaling`. Certain services only support only one policy type. For more information see the [Target Tracking Scaling Policies](https://docs&#46;aws&#46;amazon&#46;com/autoscaling/application/userguide/application-auto-scaling-target-tracking&#46;html) and [Step Scaling Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) documentation.
 * @property resourceId Resource type and unique identifier string for the resource associated with the scaling policy. Documentation can be found in the `ResourceId` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
 * @property scalableDimension Scalable dimension of the scalable target. Documentation can be found in the `ScalableDimension` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
 * @property serviceNamespace AWS service namespace of the scalable target. Documentation can be found in the `ServiceNamespace` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
 * @property stepScalingPolicyConfiguration Step scaling policy configuration, requires `policy_type = "StepScaling"` (default). See supported fields below.
 * @property targetTrackingScalingPolicyConfiguration Target tracking policy, requires `policy_type = "TargetTrackingScaling"`. See supported fields below.
 */
public data class PolicyArgs(
    public val name: Output<String>? = null,
    public val policyType: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val scalableDimension: Output<String>? = null,
    public val serviceNamespace: Output<String>? = null,
    public val stepScalingPolicyConfiguration: Output<PolicyStepScalingPolicyConfigurationArgs>? =
        null,
    public val targetTrackingScalingPolicyConfiguration:
    Output<PolicyTargetTrackingScalingPolicyConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appautoscaling.PolicyArgs> {
    override fun toJava(): com.pulumi.aws.appautoscaling.PolicyArgs =
        com.pulumi.aws.appautoscaling.PolicyArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .policyType(policyType?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .scalableDimension(scalableDimension?.applyValue({ args0 -> args0 }))
            .serviceNamespace(serviceNamespace?.applyValue({ args0 -> args0 }))
            .stepScalingPolicyConfiguration(
                stepScalingPolicyConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .targetTrackingScalingPolicyConfiguration(
                targetTrackingScalingPolicyConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [PolicyArgs].
 */
@PulumiTagMarker
public class PolicyArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var policyType: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var scalableDimension: Output<String>? = null

    private var serviceNamespace: Output<String>? = null

    private var stepScalingPolicyConfiguration: Output<PolicyStepScalingPolicyConfigurationArgs>? =
        null

    private var targetTrackingScalingPolicyConfiguration:
        Output<PolicyTargetTrackingScalingPolicyConfigurationArgs>? = null

    /**
     * @param value Name of the policy. Must be between 1 and 255 characters in length.
     */
    @JvmName("puipmoslabotbdck")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Policy type. Valid values are `StepScaling` and `TargetTrackingScaling`. Defaults to `StepScaling`. Certain services only support only one policy type. For more information see the [Target Tracking Scaling Policies](https://docs&#46;aws&#46;amazon&#46;com/autoscaling/application/userguide/application-auto-scaling-target-tracking&#46;html) and [Step Scaling Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) documentation.
     */
    @JvmName("hrohuicpjxrtjfmc")
    public suspend fun policyType(`value`: Output<String>) {
        this.policyType = value
    }

    /**
     * @param value Resource type and unique identifier string for the resource associated with the scaling policy. Documentation can be found in the `ResourceId` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
     */
    @JvmName("xvbsqmtdblsygete")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Scalable dimension of the scalable target. Documentation can be found in the `ScalableDimension` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
     */
    @JvmName("hgxfiujnommflger")
    public suspend fun scalableDimension(`value`: Output<String>) {
        this.scalableDimension = value
    }

    /**
     * @param value AWS service namespace of the scalable target. Documentation can be found in the `ServiceNamespace` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
     */
    @JvmName("mhrxjqgrgrvbqxlv")
    public suspend fun serviceNamespace(`value`: Output<String>) {
        this.serviceNamespace = value
    }

    /**
     * @param value Step scaling policy configuration, requires `policy_type = "StepScaling"` (default). See supported fields below.
     */
    @JvmName("jgujaheadualpijl")
    public suspend
    fun stepScalingPolicyConfiguration(`value`: Output<PolicyStepScalingPolicyConfigurationArgs>) {
        this.stepScalingPolicyConfiguration = value
    }

    /**
     * @param value Target tracking policy, requires `policy_type = "TargetTrackingScaling"`. See supported fields below.
     */
    @JvmName("yenrigdrkwsxenxm")
    public suspend
    fun targetTrackingScalingPolicyConfiguration(`value`: Output<PolicyTargetTrackingScalingPolicyConfigurationArgs>) {
        this.targetTrackingScalingPolicyConfiguration = value
    }

    /**
     * @param value Name of the policy. Must be between 1 and 255 characters in length.
     */
    @JvmName("ubehjgmljkrlivdv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Policy type. Valid values are `StepScaling` and `TargetTrackingScaling`. Defaults to `StepScaling`. Certain services only support only one policy type. For more information see the [Target Tracking Scaling Policies](https://docs&#46;aws&#46;amazon&#46;com/autoscaling/application/userguide/application-auto-scaling-target-tracking&#46;html) and [Step Scaling Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) documentation.
     */
    @JvmName("gbonjxdcrsskmjww")
    public suspend fun policyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value Resource type and unique identifier string for the resource associated with the scaling policy. Documentation can be found in the `ResourceId` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
     */
    @JvmName("tsddehsmijexvfuv")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Scalable dimension of the scalable target. Documentation can be found in the `ScalableDimension` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
     */
    @JvmName("bmrxfjwxibbefrxc")
    public suspend fun scalableDimension(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalableDimension = mapped
    }

    /**
     * @param value AWS service namespace of the scalable target. Documentation can be found in the `ServiceNamespace` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
     */
    @JvmName("meqwvgsqvypexued")
    public suspend fun serviceNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceNamespace = mapped
    }

    /**
     * @param value Step scaling policy configuration, requires `policy_type = "StepScaling"` (default). See supported fields below.
     */
    @JvmName("ftnvcxgqtcwxslta")
    public suspend
    fun stepScalingPolicyConfiguration(`value`: PolicyStepScalingPolicyConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stepScalingPolicyConfiguration = mapped
    }

    /**
     * @param argument Step scaling policy configuration, requires `policy_type = "StepScaling"` (default). See supported fields below.
     */
    @JvmName("ovkpgqarxobrnngb")
    public suspend
    fun stepScalingPolicyConfiguration(argument: suspend PolicyStepScalingPolicyConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = PolicyStepScalingPolicyConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.stepScalingPolicyConfiguration = mapped
    }

    /**
     * @param value Target tracking policy, requires `policy_type = "TargetTrackingScaling"`. See supported fields below.
     */
    @JvmName("nwoppedbcbbyjpps")
    public suspend
    fun targetTrackingScalingPolicyConfiguration(`value`: PolicyTargetTrackingScalingPolicyConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetTrackingScalingPolicyConfiguration = mapped
    }

    /**
     * @param argument Target tracking policy, requires `policy_type = "TargetTrackingScaling"`. See supported fields below.
     */
    @JvmName("osnosfjpsahprlba")
    public suspend
    fun targetTrackingScalingPolicyConfiguration(argument: suspend PolicyTargetTrackingScalingPolicyConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = PolicyTargetTrackingScalingPolicyConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.targetTrackingScalingPolicyConfiguration = mapped
    }

    internal fun build(): PolicyArgs = PolicyArgs(
        name = name,
        policyType = policyType,
        resourceId = resourceId,
        scalableDimension = scalableDimension,
        serviceNamespace = serviceNamespace,
        stepScalingPolicyConfiguration = stepScalingPolicyConfiguration,
        targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration,
    )
}
