@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appautoscaling.kotlin

import com.pulumi.aws.appautoscaling.kotlin.outputs.ScheduledActionScalableTargetAction
import com.pulumi.aws.appautoscaling.kotlin.outputs.ScheduledActionScalableTargetAction.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ScheduledAction].
 */
@PulumiTagMarker
public class ScheduledActionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScheduledActionArgs = ScheduledActionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScheduledActionArgsBuilder.() -> Unit) {
        val builder = ScheduledActionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ScheduledAction {
        val builtJavaResource = com.pulumi.aws.appautoscaling.ScheduledAction(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ScheduledAction(builtJavaResource)
    }
}

/**
 * Provides an Application AutoScaling ScheduledAction resource.
 * ## Example Usage
 * ### DynamoDB Table Autoscaling
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appautoscaling.Target;
 * import com.pulumi.aws.appautoscaling.TargetArgs;
 * import com.pulumi.aws.appautoscaling.ScheduledAction;
 * import com.pulumi.aws.appautoscaling.ScheduledActionArgs;
 * import com.pulumi.aws.appautoscaling.inputs.ScheduledActionScalableTargetActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dynamodbTarget = new Target("dynamodbTarget", TargetArgs.builder()
 *             .maxCapacity(100)
 *             .minCapacity(5)
 *             .resourceId("table/tableName")
 *             .scalableDimension("dynamodb:table:ReadCapacityUnits")
 *             .serviceNamespace("dynamodb")
 *             .build());
 *         var dynamodbScheduledAction = new ScheduledAction("dynamodbScheduledAction", ScheduledActionArgs.builder()
 *             .serviceNamespace(dynamodbTarget.serviceNamespace())
 *             .resourceId(dynamodbTarget.resourceId())
 *             .scalableDimension(dynamodbTarget.scalableDimension())
 *             .schedule("at(2006-01-02T15:04:05)")
 *             .scalableTargetAction(ScheduledActionScalableTargetActionArgs.builder()
 *                 .minCapacity(1)
 *                 .maxCapacity(200)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### ECS Service Autoscaling
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appautoscaling.Target;
 * import com.pulumi.aws.appautoscaling.TargetArgs;
 * import com.pulumi.aws.appautoscaling.ScheduledAction;
 * import com.pulumi.aws.appautoscaling.ScheduledActionArgs;
 * import com.pulumi.aws.appautoscaling.inputs.ScheduledActionScalableTargetActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ecsTarget = new Target("ecsTarget", TargetArgs.builder()
 *             .maxCapacity(4)
 *             .minCapacity(1)
 *             .resourceId("service/clusterName/serviceName")
 *             .scalableDimension("ecs:service:DesiredCount")
 *             .serviceNamespace("ecs")
 *             .build());
 *         var ecsScheduledAction = new ScheduledAction("ecsScheduledAction", ScheduledActionArgs.builder()
 *             .serviceNamespace(ecsTarget.serviceNamespace())
 *             .resourceId(ecsTarget.resourceId())
 *             .scalableDimension(ecsTarget.scalableDimension())
 *             .schedule("at(2006-01-02T15:04:05)")
 *             .scalableTargetAction(ScheduledActionScalableTargetActionArgs.builder()
 *                 .minCapacity(1)
 *                 .maxCapacity(10)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 */
public class ScheduledAction internal constructor(
    override val javaResource: com.pulumi.aws.appautoscaling.ScheduledAction,
) : KotlinCustomResource(javaResource, ScheduledActionMapper) {
    /**
     * ARN of the scheduled action.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Date and time for the scheduled action to end in RFC 3339 format. The timezone is not affected by the setting of `timezone`.
     */
    public val endTime: Output<String>?
        get() = javaResource.endTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the scheduled action.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Identifier of the resource associated with the scheduled action. Documentation can be found in the `ResourceId` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScheduledAction.html)
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })

    /**
     * Scalable dimension. Documentation can be found in the `ScalableDimension` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScheduledAction.html) Example: ecs:service:DesiredCount
     */
    public val scalableDimension: Output<String>
        get() = javaResource.scalableDimension().applyValue({ args0 -> args0 })

    /**
     * New minimum and maximum capacity. You can set both values or just one. See below
     */
    public val scalableTargetAction: Output<ScheduledActionScalableTargetAction>
        get() = javaResource.scalableTargetAction().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Schedule for this action. The following formats are supported: At expressions - at(yyyy-mm-ddThh:mm:ss), Rate expressions - rate(valueunit), Cron expressions - cron(fields). Times for at expressions and cron expressions are evaluated using the time zone configured in `timezone`. Documentation can be found in the `Timezone` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScheduledAction.html)
     */
    public val schedule: Output<String>
        get() = javaResource.schedule().applyValue({ args0 -> args0 })

    /**
     * Namespace of the AWS service. Documentation can be found in the `ServiceNamespace` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScheduledAction.html) Example: ecs
     */
    public val serviceNamespace: Output<String>
        get() = javaResource.serviceNamespace().applyValue({ args0 -> args0 })

    /**
     * Date and time for the scheduled action to start in RFC 3339 format. The timezone is not affected by the setting of `timezone`.
     */
    public val startTime: Output<String>?
        get() = javaResource.startTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Time zone used when setting a scheduled action by using an at or cron expression. Does not affect timezone for `start_time` and `end_time`. Valid values are the [canonical names of the IANA time zones supported by Joda-Time](https://www.joda.org/joda-time/timezones.html), such as `Etc/GMT+9` or `Pacific/Tahiti`. Default is `UTC`.
     */
    public val timezone: Output<String>?
        get() = javaResource.timezone().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ScheduledActionMapper : ResourceMapper<ScheduledAction> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appautoscaling.ScheduledAction::class == javaResource::class

    override fun map(javaResource: Resource): ScheduledAction = ScheduledAction(
        javaResource as
            com.pulumi.aws.appautoscaling.ScheduledAction,
    )
}

/**
 * @see [ScheduledAction].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ScheduledAction].
 */
public suspend fun scheduledAction(
    name: String,
    block: suspend ScheduledActionResourceBuilder.() -> Unit,
): ScheduledAction {
    val builder = ScheduledActionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ScheduledAction].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scheduledAction(name: String): ScheduledAction {
    val builder = ScheduledActionResourceBuilder()
    builder.name(name)
    return builder.build()
}
