@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appautoscaling.kotlin

import com.pulumi.aws.appautoscaling.ScheduledActionArgs.builder
import com.pulumi.aws.appautoscaling.kotlin.inputs.ScheduledActionScalableTargetActionArgs
import com.pulumi.aws.appautoscaling.kotlin.inputs.ScheduledActionScalableTargetActionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an Application AutoScaling ScheduledAction resource.
 * ## Example Usage
 * ### DynamoDB Table Autoscaling
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appautoscaling.Target;
 * import com.pulumi.aws.appautoscaling.TargetArgs;
 * import com.pulumi.aws.appautoscaling.ScheduledAction;
 * import com.pulumi.aws.appautoscaling.ScheduledActionArgs;
 * import com.pulumi.aws.appautoscaling.inputs.ScheduledActionScalableTargetActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dynamodbTarget = new Target("dynamodbTarget", TargetArgs.builder()
 *             .maxCapacity(100)
 *             .minCapacity(5)
 *             .resourceId("table/tableName")
 *             .scalableDimension("dynamodb:table:ReadCapacityUnits")
 *             .serviceNamespace("dynamodb")
 *             .build());
 *         var dynamodbScheduledAction = new ScheduledAction("dynamodbScheduledAction", ScheduledActionArgs.builder()
 *             .serviceNamespace(dynamodbTarget.serviceNamespace())
 *             .resourceId(dynamodbTarget.resourceId())
 *             .scalableDimension(dynamodbTarget.scalableDimension())
 *             .schedule("at(2006-01-02T15:04:05)")
 *             .scalableTargetAction(ScheduledActionScalableTargetActionArgs.builder()
 *                 .minCapacity(1)
 *                 .maxCapacity(200)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### ECS Service Autoscaling
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appautoscaling.Target;
 * import com.pulumi.aws.appautoscaling.TargetArgs;
 * import com.pulumi.aws.appautoscaling.ScheduledAction;
 * import com.pulumi.aws.appautoscaling.ScheduledActionArgs;
 * import com.pulumi.aws.appautoscaling.inputs.ScheduledActionScalableTargetActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ecsTarget = new Target("ecsTarget", TargetArgs.builder()
 *             .maxCapacity(4)
 *             .minCapacity(1)
 *             .resourceId("service/clusterName/serviceName")
 *             .scalableDimension("ecs:service:DesiredCount")
 *             .serviceNamespace("ecs")
 *             .build());
 *         var ecsScheduledAction = new ScheduledAction("ecsScheduledAction", ScheduledActionArgs.builder()
 *             .serviceNamespace(ecsTarget.serviceNamespace())
 *             .resourceId(ecsTarget.resourceId())
 *             .scalableDimension(ecsTarget.scalableDimension())
 *             .schedule("at(2006-01-02T15:04:05)")
 *             .scalableTargetAction(ScheduledActionScalableTargetActionArgs.builder()
 *                 .minCapacity(1)
 *                 .maxCapacity(10)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * @property endTime Date and time for the scheduled action to end in RFC 3339 format. The timezone is not affected by the setting of `timezone`.
 * @property name Name of the scheduled action.
 * @property resourceId Identifier of the resource associated with the scheduled action. Documentation can be found in the `ResourceId` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScheduledAction.html)
 * @property scalableDimension Scalable dimension. Documentation can be found in the `ScalableDimension` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScheduledAction.html) Example: ecs:service:DesiredCount
 * @property scalableTargetAction New minimum and maximum capacity. You can set both values or just one. See below
 * @property schedule Schedule for this action. The following formats are supported: At expressions - at(yyyy-mm-ddThh:mm:ss), Rate expressions - rate(valueunit), Cron expressions - cron(fields). Times for at expressions and cron expressions are evaluated using the time zone configured in `timezone`. Documentation can be found in the `Timezone` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScheduledAction.html)
 * @property serviceNamespace Namespace of the AWS service. Documentation can be found in the `ServiceNamespace` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScheduledAction.html) Example: ecs
 * @property startTime Date and time for the scheduled action to start in RFC 3339 format. The timezone is not affected by the setting of `timezone`.
 * @property timezone Time zone used when setting a scheduled action by using an at or cron expression. Does not affect timezone for `start_time` and `end_time`. Valid values are the [canonical names of the IANA time zones supported by Joda-Time](https://www.joda.org/joda-time/timezones.html), such as `Etc/GMT+9` or `Pacific/Tahiti`. Default is `UTC`.
 */
public data class ScheduledActionArgs(
    public val endTime: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val scalableDimension: Output<String>? = null,
    public val scalableTargetAction: Output<ScheduledActionScalableTargetActionArgs>? = null,
    public val schedule: Output<String>? = null,
    public val serviceNamespace: Output<String>? = null,
    public val startTime: Output<String>? = null,
    public val timezone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appautoscaling.ScheduledActionArgs> {
    override fun toJava(): com.pulumi.aws.appautoscaling.ScheduledActionArgs =
        com.pulumi.aws.appautoscaling.ScheduledActionArgs.builder()
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .scalableDimension(scalableDimension?.applyValue({ args0 -> args0 }))
            .scalableTargetAction(
                scalableTargetAction?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .schedule(schedule?.applyValue({ args0 -> args0 }))
            .serviceNamespace(serviceNamespace?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 }))
            .timezone(timezone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduledActionArgs].
 */
@PulumiTagMarker
public class ScheduledActionArgsBuilder internal constructor() {
    private var endTime: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var scalableDimension: Output<String>? = null

    private var scalableTargetAction: Output<ScheduledActionScalableTargetActionArgs>? = null

    private var schedule: Output<String>? = null

    private var serviceNamespace: Output<String>? = null

    private var startTime: Output<String>? = null

    private var timezone: Output<String>? = null

    /**
     * @param value Date and time for the scheduled action to end in RFC 3339 format. The timezone is not affected by the setting of `timezone`.
     */
    @JvmName("bywejpoynwglrqpk")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value Name of the scheduled action.
     */
    @JvmName("exjrhokspjkvuntk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Identifier of the resource associated with the scheduled action. Documentation can be found in the `ResourceId` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScheduledAction.html)
     */
    @JvmName("bxbrsiphlpjpgaxv")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Scalable dimension. Documentation can be found in the `ScalableDimension` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScheduledAction.html) Example: ecs:service:DesiredCount
     */
    @JvmName("qcoqvdrladmewoip")
    public suspend fun scalableDimension(`value`: Output<String>) {
        this.scalableDimension = value
    }

    /**
     * @param value New minimum and maximum capacity. You can set both values or just one. See below
     */
    @JvmName("jdmgamqcrxemtfyj")
    public suspend
    fun scalableTargetAction(`value`: Output<ScheduledActionScalableTargetActionArgs>) {
        this.scalableTargetAction = value
    }

    /**
     * @param value Schedule for this action. The following formats are supported: At expressions - at(yyyy-mm-ddThh:mm:ss), Rate expressions - rate(valueunit), Cron expressions - cron(fields). Times for at expressions and cron expressions are evaluated using the time zone configured in `timezone`. Documentation can be found in the `Timezone` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScheduledAction.html)
     */
    @JvmName("fjdmktnjdojgdgxk")
    public suspend fun schedule(`value`: Output<String>) {
        this.schedule = value
    }

    /**
     * @param value Namespace of the AWS service. Documentation can be found in the `ServiceNamespace` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScheduledAction.html) Example: ecs
     */
    @JvmName("fdyceueifeinkqlp")
    public suspend fun serviceNamespace(`value`: Output<String>) {
        this.serviceNamespace = value
    }

    /**
     * @param value Date and time for the scheduled action to start in RFC 3339 format. The timezone is not affected by the setting of `timezone`.
     */
    @JvmName("voonxxtigofwelld")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Time zone used when setting a scheduled action by using an at or cron expression. Does not affect timezone for `start_time` and `end_time`. Valid values are the [canonical names of the IANA time zones supported by Joda-Time](https://www.joda.org/joda-time/timezones.html), such as `Etc/GMT+9` or `Pacific/Tahiti`. Default is `UTC`.
     */
    @JvmName("eixnxiotwypctcdf")
    public suspend fun timezone(`value`: Output<String>) {
        this.timezone = value
    }

    /**
     * @param value Date and time for the scheduled action to end in RFC 3339 format. The timezone is not affected by the setting of `timezone`.
     */
    @JvmName("aswmsjnvicujkyou")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value Name of the scheduled action.
     */
    @JvmName("csunybfksmgrknrg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Identifier of the resource associated with the scheduled action. Documentation can be found in the `ResourceId` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScheduledAction.html)
     */
    @JvmName("mirfkkjqjgqdgrpf")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Scalable dimension. Documentation can be found in the `ScalableDimension` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScheduledAction.html) Example: ecs:service:DesiredCount
     */
    @JvmName("cviitqbcvudjvhys")
    public suspend fun scalableDimension(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalableDimension = mapped
    }

    /**
     * @param value New minimum and maximum capacity. You can set both values or just one. See below
     */
    @JvmName("ymmxuxhmxcgapaat")
    public suspend fun scalableTargetAction(`value`: ScheduledActionScalableTargetActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalableTargetAction = mapped
    }

    /**
     * @param argument New minimum and maximum capacity. You can set both values or just one. See below
     */
    @JvmName("xiytummubfgafeev")
    public suspend
    fun scalableTargetAction(argument: suspend ScheduledActionScalableTargetActionArgsBuilder.() -> Unit) {
        val toBeMapped = ScheduledActionScalableTargetActionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.scalableTargetAction = mapped
    }

    /**
     * @param value Schedule for this action. The following formats are supported: At expressions - at(yyyy-mm-ddThh:mm:ss), Rate expressions - rate(valueunit), Cron expressions - cron(fields). Times for at expressions and cron expressions are evaluated using the time zone configured in `timezone`. Documentation can be found in the `Timezone` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScheduledAction.html)
     */
    @JvmName("kvclplvxkimmpnvx")
    public suspend fun schedule(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param value Namespace of the AWS service. Documentation can be found in the `ServiceNamespace` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScheduledAction.html) Example: ecs
     */
    @JvmName("uxuuucmswallwnpb")
    public suspend fun serviceNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceNamespace = mapped
    }

    /**
     * @param value Date and time for the scheduled action to start in RFC 3339 format. The timezone is not affected by the setting of `timezone`.
     */
    @JvmName("wdcvkypodrrlewhj")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value Time zone used when setting a scheduled action by using an at or cron expression. Does not affect timezone for `start_time` and `end_time`. Valid values are the [canonical names of the IANA time zones supported by Joda-Time](https://www.joda.org/joda-time/timezones.html), such as `Etc/GMT+9` or `Pacific/Tahiti`. Default is `UTC`.
     */
    @JvmName("ehifbkwfhduwnlkb")
    public suspend fun timezone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timezone = mapped
    }

    internal fun build(): ScheduledActionArgs = ScheduledActionArgs(
        endTime = endTime,
        name = name,
        resourceId = resourceId,
        scalableDimension = scalableDimension,
        scalableTargetAction = scalableTargetAction,
        schedule = schedule,
        serviceNamespace = serviceNamespace,
        startTime = startTime,
        timezone = timezone,
    )
}
