@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appautoscaling.kotlin

import com.pulumi.aws.appautoscaling.TargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Application AutoScaling ScalableTarget resource. To manage policies which get attached to the target, see the `aws.appautoscaling.Policy` resource.
 * > **NOTE:** Scalable targets created before 2023-03-20 may not have an assigned `arn`. These resource cannot use `tags` or participate in `default_tags`. To prevent `pulumi preview` showing differences that can never be reconciled, use the `lifecycle.ignore_changes` meta-argument. See the example below.
 * > **NOTE:** The [Application Auto Scaling service automatically attempts to manage IAM Service-Linked Roles](https://docs.aws.amazon.com/autoscaling/application/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-roles) when registering certain service namespaces for the first time. To manually manage this role, see the `aws.iam.ServiceLinkedRole` resource.
 * ## Example Usage
 * ### DynamoDB Table Autoscaling
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appautoscaling.Target;
 * import com.pulumi.aws.appautoscaling.TargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dynamodbTableReadTarget = new Target("dynamodbTableReadTarget", TargetArgs.builder()
 *             .maxCapacity(100)
 *             .minCapacity(5)
 *             .resourceId(String.format("table/%s", aws_dynamodb_table.example().name()))
 *             .scalableDimension("dynamodb:table:ReadCapacityUnits")
 *             .serviceNamespace("dynamodb")
 *             .build());
 *     }
 * }
 * ```
 * ### DynamoDB Index Autoscaling
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appautoscaling.Target;
 * import com.pulumi.aws.appautoscaling.TargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dynamodbIndexReadTarget = new Target("dynamodbIndexReadTarget", TargetArgs.builder()
 *             .maxCapacity(100)
 *             .minCapacity(5)
 *             .resourceId(String.format("table/%s/index/%s", aws_dynamodb_table.example().name(),var_.index_name()))
 *             .scalableDimension("dynamodb:index:ReadCapacityUnits")
 *             .serviceNamespace("dynamodb")
 *             .build());
 *     }
 * }
 * ```
 * ### ECS Service Autoscaling
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appautoscaling.Target;
 * import com.pulumi.aws.appautoscaling.TargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ecsTarget = new Target("ecsTarget", TargetArgs.builder()
 *             .maxCapacity(4)
 *             .minCapacity(1)
 *             .resourceId(String.format("service/%s/%s", aws_ecs_cluster.example().name(),aws_ecs_service.example().name()))
 *             .scalableDimension("ecs:service:DesiredCount")
 *             .serviceNamespace("ecs")
 *             .build());
 *     }
 * }
 * ```
 * ### Aurora Read Replica Autoscaling
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appautoscaling.Target;
 * import com.pulumi.aws.appautoscaling.TargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicas = new Target("replicas", TargetArgs.builder()
 *             .maxCapacity(15)
 *             .minCapacity(1)
 *             .resourceId(String.format("cluster:%s", aws_rds_cluster.example().id()))
 *             .scalableDimension("rds:cluster:ReadReplicaCount")
 *             .serviceNamespace("rds")
 *             .build());
 *     }
 * }
 * ```
 * ### Suppressing `tags_all` Differences For Older Resources
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appautoscaling.Target;
 * import com.pulumi.aws.appautoscaling.TargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ecsTarget = new Target("ecsTarget", TargetArgs.builder()
 *             .maxCapacity(4)
 *             .minCapacity(1)
 *             .resourceId(String.format("service/%s/%s", aws_ecs_cluster.example().name(),aws_ecs_service.example().name()))
 *             .scalableDimension("ecs:service:DesiredCount")
 *             .serviceNamespace("ecs")
 *             .build());
 *     }
 * }
 * ```
 * ### MSK / Kafka Autoscaling
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appautoscaling.Target;
 * import com.pulumi.aws.appautoscaling.TargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mskTarget = new Target("mskTarget", TargetArgs.builder()
 *             .maxCapacity(8)
 *             .minCapacity(1)
 *             .resourceId(aws_msk_cluster.example().arn())
 *             .scalableDimension("kafka:broker-storage:VolumeSize")
 *             .serviceNamespace("kafka")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Application AutoScaling Target using the `service-namespace` , `resource-id` and `scalable-dimension` separated by `/`. For example:
 * ```sh
 *  $ pulumi import aws:appautoscaling/target:Target test-target service-namespace/resource-id/scalable-dimension
 * ```
 * @property maxCapacity Max capacity of the scalable target.
 * @property minCapacity Min capacity of the scalable target.
 * @property resourceId Resource type and unique identifier string for the resource associated with the scaling policy. Documentation can be found in the `ResourceId` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html#API_RegisterScalableTarget_RequestParameters)
 * @property roleArn ARN of the IAM role that allows Application AutoScaling to modify your scalable target on your behalf. This defaults to an IAM Service-Linked Role for most services and custom IAM Roles are ignored by the API for those namespaces. See the [AWS Application Auto Scaling documentation](https://docs.aws.amazon.com/autoscaling/application/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-roles) for more information about how this service interacts with IAM.
 * @property scalableDimension Scalable dimension of the scalable target. Documentation can be found in the `ScalableDimension` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html#API_RegisterScalableTarget_RequestParameters)
 * @property serviceNamespace AWS service namespace of the scalable target. Documentation can be found in the `ServiceNamespace` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html#API_RegisterScalableTarget_RequestParameters)
 * @property tags Map of tags to assign to the scalable target. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class TargetArgs(
    public val maxCapacity: Output<Int>? = null,
    public val minCapacity: Output<Int>? = null,
    public val resourceId: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val scalableDimension: Output<String>? = null,
    public val serviceNamespace: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appautoscaling.TargetArgs> {
    override fun toJava(): com.pulumi.aws.appautoscaling.TargetArgs =
        com.pulumi.aws.appautoscaling.TargetArgs.builder()
            .maxCapacity(maxCapacity?.applyValue({ args0 -> args0 }))
            .minCapacity(minCapacity?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .scalableDimension(scalableDimension?.applyValue({ args0 -> args0 }))
            .serviceNamespace(serviceNamespace?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [TargetArgs].
 */
@PulumiTagMarker
public class TargetArgsBuilder internal constructor() {
    private var maxCapacity: Output<Int>? = null

    private var minCapacity: Output<Int>? = null

    private var resourceId: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var scalableDimension: Output<String>? = null

    private var serviceNamespace: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Max capacity of the scalable target.
     */
    @JvmName("bdigfdfhtfddelsc")
    public suspend fun maxCapacity(`value`: Output<Int>) {
        this.maxCapacity = value
    }

    /**
     * @param value Min capacity of the scalable target.
     */
    @JvmName("tnsbhyotnmlhikuw")
    public suspend fun minCapacity(`value`: Output<Int>) {
        this.minCapacity = value
    }

    /**
     * @param value Resource type and unique identifier string for the resource associated with the scaling policy. Documentation can be found in the `ResourceId` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html#API_RegisterScalableTarget_RequestParameters)
     */
    @JvmName("wjjglaualadjhqog")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value ARN of the IAM role that allows Application AutoScaling to modify your scalable target on your behalf. This defaults to an IAM Service-Linked Role for most services and custom IAM Roles are ignored by the API for those namespaces. See the [AWS Application Auto Scaling documentation](https://docs.aws.amazon.com/autoscaling/application/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-roles) for more information about how this service interacts with IAM.
     */
    @JvmName("jaehhkkrutwrdvfq")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Scalable dimension of the scalable target. Documentation can be found in the `ScalableDimension` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html#API_RegisterScalableTarget_RequestParameters)
     */
    @JvmName("vyueyijtahgnlmvp")
    public suspend fun scalableDimension(`value`: Output<String>) {
        this.scalableDimension = value
    }

    /**
     * @param value AWS service namespace of the scalable target. Documentation can be found in the `ServiceNamespace` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html#API_RegisterScalableTarget_RequestParameters)
     */
    @JvmName("dlgwsubheutpufgf")
    public suspend fun serviceNamespace(`value`: Output<String>) {
        this.serviceNamespace = value
    }

    /**
     * @param value Map of tags to assign to the scalable target. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yebgjrmdpgcvsyrd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Max capacity of the scalable target.
     */
    @JvmName("pnfbfkviqvfemqqn")
    public suspend fun maxCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxCapacity = mapped
    }

    /**
     * @param value Min capacity of the scalable target.
     */
    @JvmName("ufloxrwdcmeuimqx")
    public suspend fun minCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minCapacity = mapped
    }

    /**
     * @param value Resource type and unique identifier string for the resource associated with the scaling policy. Documentation can be found in the `ResourceId` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html#API_RegisterScalableTarget_RequestParameters)
     */
    @JvmName("hipqcylckdlwkxma")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value ARN of the IAM role that allows Application AutoScaling to modify your scalable target on your behalf. This defaults to an IAM Service-Linked Role for most services and custom IAM Roles are ignored by the API for those namespaces. See the [AWS Application Auto Scaling documentation](https://docs.aws.amazon.com/autoscaling/application/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-roles) for more information about how this service interacts with IAM.
     */
    @JvmName("adokmdpmmfkwmuiy")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Scalable dimension of the scalable target. Documentation can be found in the `ScalableDimension` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html#API_RegisterScalableTarget_RequestParameters)
     */
    @JvmName("wabdbcaqrwnjuvqt")
    public suspend fun scalableDimension(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalableDimension = mapped
    }

    /**
     * @param value AWS service namespace of the scalable target. Documentation can be found in the `ServiceNamespace` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html#API_RegisterScalableTarget_RequestParameters)
     */
    @JvmName("acitryvwblcfjxtf")
    public suspend fun serviceNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceNamespace = mapped
    }

    /**
     * @param value Map of tags to assign to the scalable target. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fpgsatqjvxrgtihr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the scalable target. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("plwwmxacsnjogrtp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): TargetArgs = TargetArgs(
        maxCapacity = maxCapacity,
        minCapacity = minCapacity,
        resourceId = resourceId,
        roleArn = roleArn,
        scalableDimension = scalableDimension,
        serviceNamespace = serviceNamespace,
        tags = tags,
    )
}
