@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appautoscaling.kotlin.inputs

import com.pulumi.aws.appautoscaling.inputs.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property metricIntervalLowerBound Lower bound for the difference between the alarm threshold and the CloudWatch metric. Without a value, AWS will treat this bound as negative infinity.
 * @property metricIntervalUpperBound Upper bound for the difference between the alarm threshold and the CloudWatch metric. Without a value, AWS will treat this bound as infinity. The upper bound must be greater than the lower bound.
 * @property scalingAdjustment Number of members by which to scale, when the adjustment bounds are breached. A positive value scales up. A negative value scales down.
 */
public data class PolicyStepScalingPolicyConfigurationStepAdjustmentArgs(
    public val metricIntervalLowerBound: Output<String>? = null,
    public val metricIntervalUpperBound: Output<String>? = null,
    public val scalingAdjustment: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.appautoscaling.inputs.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs> {
    override fun toJava():
        com.pulumi.aws.appautoscaling.inputs.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs =
        com.pulumi.aws.appautoscaling.inputs.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs.builder()
            .metricIntervalLowerBound(metricIntervalLowerBound?.applyValue({ args0 -> args0 }))
            .metricIntervalUpperBound(metricIntervalUpperBound?.applyValue({ args0 -> args0 }))
            .scalingAdjustment(scalingAdjustment.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyStepScalingPolicyConfigurationStepAdjustmentArgs].
 */
@PulumiTagMarker
public class PolicyStepScalingPolicyConfigurationStepAdjustmentArgsBuilder internal constructor() {
    private var metricIntervalLowerBound: Output<String>? = null

    private var metricIntervalUpperBound: Output<String>? = null

    private var scalingAdjustment: Output<Int>? = null

    /**
     * @param value Lower bound for the difference between the alarm threshold and the CloudWatch metric. Without a value, AWS will treat this bound as negative infinity.
     */
    @JvmName("hifhpcnxqnygrjsh")
    public suspend fun metricIntervalLowerBound(`value`: Output<String>) {
        this.metricIntervalLowerBound = value
    }

    /**
     * @param value Upper bound for the difference between the alarm threshold and the CloudWatch metric. Without a value, AWS will treat this bound as infinity. The upper bound must be greater than the lower bound.
     */
    @JvmName("qohusgkitxuhbugl")
    public suspend fun metricIntervalUpperBound(`value`: Output<String>) {
        this.metricIntervalUpperBound = value
    }

    /**
     * @param value Number of members by which to scale, when the adjustment bounds are breached. A positive value scales up. A negative value scales down.
     */
    @JvmName("tpshjgvgnbppnsmu")
    public suspend fun scalingAdjustment(`value`: Output<Int>) {
        this.scalingAdjustment = value
    }

    /**
     * @param value Lower bound for the difference between the alarm threshold and the CloudWatch metric. Without a value, AWS will treat this bound as negative infinity.
     */
    @JvmName("uqqfjpyqgeilplfk")
    public suspend fun metricIntervalLowerBound(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricIntervalLowerBound = mapped
    }

    /**
     * @param value Upper bound for the difference between the alarm threshold and the CloudWatch metric. Without a value, AWS will treat this bound as infinity. The upper bound must be greater than the lower bound.
     */
    @JvmName("ijibvggscpxevgwt")
    public suspend fun metricIntervalUpperBound(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricIntervalUpperBound = mapped
    }

    /**
     * @param value Number of members by which to scale, when the adjustment bounds are breached. A positive value scales up. A negative value scales down.
     */
    @JvmName("aaxbtupccvpiwaah")
    public suspend fun scalingAdjustment(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scalingAdjustment = mapped
    }

    internal fun build(): PolicyStepScalingPolicyConfigurationStepAdjustmentArgs =
        PolicyStepScalingPolicyConfigurationStepAdjustmentArgs(
            metricIntervalLowerBound = metricIntervalLowerBound,
            metricIntervalUpperBound = metricIntervalUpperBound,
            scalingAdjustment = scalingAdjustment ?: throw PulumiNullFieldException("scalingAdjustment"),
        )
}
