@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appautoscaling.kotlin.inputs

import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property predefinedMetricType Metric type.
 * @property resourceLabel Reserved for future use if the `predefined_metric_type` is not `ALBRequestCountPerTarget`. If the `predefined_metric_type` is `ALBRequestCountPerTarget`, you must specify this argument. Documentation can be found at: [AWS Predefined Scaling Metric Specification](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_PredefinedScalingMetricSpecification.html). Must be less than or equal to 1023 characters in length.
 */
public data class PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs(
    public val predefinedMetricType: Output<String>,
    public val resourceLabel: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs> {
    override fun toJava():
        com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs =
        com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs.builder()
            .predefinedMetricType(predefinedMetricType.applyValue({ args0 -> args0 }))
            .resourceLabel(resourceLabel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs].
 */
@PulumiTagMarker
public class PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgsBuilder
internal constructor() {
    private var predefinedMetricType: Output<String>? = null

    private var resourceLabel: Output<String>? = null

    /**
     * @param value Metric type.
     */
    @JvmName("ggxavkycyoyjrjfy")
    public suspend fun predefinedMetricType(`value`: Output<String>) {
        this.predefinedMetricType = value
    }

    /**
     * @param value Reserved for future use if the `predefined_metric_type` is not `ALBRequestCountPerTarget`. If the `predefined_metric_type` is `ALBRequestCountPerTarget`, you must specify this argument. Documentation can be found at: [AWS Predefined Scaling Metric Specification](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_PredefinedScalingMetricSpecification.html). Must be less than or equal to 1023 characters in length.
     */
    @JvmName("bxwkbskfnifpsjkq")
    public suspend fun resourceLabel(`value`: Output<String>) {
        this.resourceLabel = value
    }

    /**
     * @param value Metric type.
     */
    @JvmName("vwrymwjevmwjvoxx")
    public suspend fun predefinedMetricType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.predefinedMetricType = mapped
    }

    /**
     * @param value Reserved for future use if the `predefined_metric_type` is not `ALBRequestCountPerTarget`. If the `predefined_metric_type` is `ALBRequestCountPerTarget`, you must specify this argument. Documentation can be found at: [AWS Predefined Scaling Metric Specification](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_PredefinedScalingMetricSpecification.html). Must be less than or equal to 1023 characters in length.
     */
    @JvmName("fumbsdttbxxsbauq")
    public suspend fun resourceLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceLabel = mapped
    }

    internal fun build():
        PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs =
        PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs(
            predefinedMetricType = predefinedMetricType ?: throw
                PulumiNullFieldException("predefinedMetricType"),
            resourceLabel = resourceLabel,
        )
}
