@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appautoscaling.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property customizedMetricSpecification Custom CloudWatch metric. Documentation can be found  at: [AWS Customized Metric Specification](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_CustomizedMetricSpecification.html). See supported fields below.
 * @property disableScaleIn Whether scale in by the target tracking policy is disabled. If the value is true, scale in is disabled and the target tracking policy won't remove capacity from the scalable resource. Otherwise, scale in is enabled and the target tracking policy can remove capacity from the scalable resource. The default value is `false`.
 * @property predefinedMetricSpecification Predefined metric. See supported fields below.
 * @property scaleInCooldown Amount of time, in seconds, after a scale in activity completes before another scale in activity can start.
 * @property scaleOutCooldown Amount of time, in seconds, after a scale out activity completes before another scale out activity can start.
 * @property targetValue Target value for the metric.
 */
public data class PolicyTargetTrackingScalingPolicyConfiguration(
    public val customizedMetricSpecification:
    PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecification? = null,
    public val disableScaleIn: Boolean? = null,
    public val predefinedMetricSpecification:
    PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecification? = null,
    public val scaleInCooldown: Int? = null,
    public val scaleOutCooldown: Int? = null,
    public val targetValue: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appautoscaling.outputs.PolicyTargetTrackingScalingPolicyConfiguration):
            PolicyTargetTrackingScalingPolicyConfiguration =
            PolicyTargetTrackingScalingPolicyConfiguration(
                customizedMetricSpecification = javaType.customizedMetricSpecification().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appautoscaling.kotlin.outputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecification.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                disableScaleIn = javaType.disableScaleIn().map({ args0 -> args0 }).orElse(null),
                predefinedMetricSpecification = javaType.predefinedMetricSpecification().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appautoscaling.kotlin.outputs.PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecification.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                scaleInCooldown = javaType.scaleInCooldown().map({ args0 -> args0 }).orElse(null),
                scaleOutCooldown = javaType.scaleOutCooldown().map({ args0 -> args0 }).orElse(null),
                targetValue = javaType.targetValue(),
            )
    }
}
