@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appautoscaling.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dimensions Dimensions of the metric.
 * @property metricName Name of the metric.
 * @property metrics Metrics to include, as a metric data query.
 * @property namespace Namespace of the metric.
 * @property statistic Statistic of the metric. Valid values: `Average`, `Minimum`, `Maximum`, `SampleCount`, and `Sum`.
 * @property unit Unit of the metrics to return.
 */
public data class PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecification(
    public val dimensions:
    List<PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimension>? =
        null,
    public val metricName: String? = null,
    public val metrics:
    List<PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetric>? =
        null,
    public val namespace: String? = null,
    public val statistic: String? = null,
    public val unit: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appautoscaling.outputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecification):
            PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecification =
            PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecification(
                dimensions = javaType.dimensions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appautoscaling.kotlin.outputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimension.Companion.toKotlin(args0)
                    })
                }),
                metricName = javaType.metricName().map({ args0 -> args0 }).orElse(null),
                metrics = javaType.metrics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appautoscaling.kotlin.outputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetric.Companion.toKotlin(args0)
                    })
                }),
                namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
                statistic = javaType.statistic().map({ args0 -> args0 }).orElse(null),
                unit = javaType.unit().map({ args0 -> args0 }).orElse(null),
            )
    }
}
