@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appautoscaling.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property predefinedMetricType Metric type.
 * @property resourceLabel Reserved for future use if the `predefined_metric_type` is not `ALBRequestCountPerTarget`. If the `predefined_metric_type` is `ALBRequestCountPerTarget`, you must specify this argument. Documentation can be found at: [AWS Predefined Scaling Metric Specification](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_PredefinedScalingMetricSpecification.html). Must be less than or equal to 1023 characters in length.
 */
public data class PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecification(
    public val predefinedMetricType: String,
    public val resourceLabel: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appautoscaling.outputs.PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecification):
            PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecification =
            PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecification(
                predefinedMetricType = javaType.predefinedMetricType(),
                resourceLabel = javaType.resourceLabel().map({ args0 -> args0 }).orElse(null),
            )
    }
}
