@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin

import com.pulumi.aws.appconfig.AppconfigFunctions.getConfigurationProfilePlain
import com.pulumi.aws.appconfig.AppconfigFunctions.getConfigurationProfilesPlain
import com.pulumi.aws.appconfig.AppconfigFunctions.getEnvironmentPlain
import com.pulumi.aws.appconfig.AppconfigFunctions.getEnvironmentsPlain
import com.pulumi.aws.appconfig.kotlin.inputs.GetConfigurationProfilePlainArgs
import com.pulumi.aws.appconfig.kotlin.inputs.GetConfigurationProfilePlainArgsBuilder
import com.pulumi.aws.appconfig.kotlin.inputs.GetConfigurationProfilesPlainArgs
import com.pulumi.aws.appconfig.kotlin.inputs.GetConfigurationProfilesPlainArgsBuilder
import com.pulumi.aws.appconfig.kotlin.inputs.GetEnvironmentPlainArgs
import com.pulumi.aws.appconfig.kotlin.inputs.GetEnvironmentPlainArgsBuilder
import com.pulumi.aws.appconfig.kotlin.inputs.GetEnvironmentsPlainArgs
import com.pulumi.aws.appconfig.kotlin.inputs.GetEnvironmentsPlainArgsBuilder
import com.pulumi.aws.appconfig.kotlin.outputs.GetConfigurationProfileResult
import com.pulumi.aws.appconfig.kotlin.outputs.GetConfigurationProfilesResult
import com.pulumi.aws.appconfig.kotlin.outputs.GetEnvironmentResult
import com.pulumi.aws.appconfig.kotlin.outputs.GetEnvironmentsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.appconfig.kotlin.outputs.GetConfigurationProfileResult.Companion.toKotlin as getConfigurationProfileResultToKotlin
import com.pulumi.aws.appconfig.kotlin.outputs.GetConfigurationProfilesResult.Companion.toKotlin as getConfigurationProfilesResultToKotlin
import com.pulumi.aws.appconfig.kotlin.outputs.GetEnvironmentResult.Companion.toKotlin as getEnvironmentResultToKotlin
import com.pulumi.aws.appconfig.kotlin.outputs.GetEnvironmentsResult.Companion.toKotlin as getEnvironmentsResultToKotlin

public object AppconfigFunctions {
    /**
     * Provides access to an AppConfig Configuration Profile.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.appconfig.AppconfigFunctions;
     * import com.pulumi.aws.appconfig.inputs.GetConfigurationProfileArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AppconfigFunctions.getConfigurationProfile(GetConfigurationProfileArgs.builder()
     *             .applicationId("b5d5gpj")
     *             .configurationProfileId("qrbb1c1")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getConfigurationProfile.
     * @return A collection of values returned by getConfigurationProfile.
     */
    public suspend fun getConfigurationProfile(argument: GetConfigurationProfilePlainArgs):
        GetConfigurationProfileResult =
        getConfigurationProfileResultToKotlin(getConfigurationProfilePlain(argument.toJava()).await())

    /**
     * @see [getConfigurationProfile].
     * @param applicationId ID of the AppConfig application to which this configuration profile belongs.
     * @param configurationProfileId ID of the Configuration Profile.
     * @param tags Map of tags for the resource.
     * @return A collection of values returned by getConfigurationProfile.
     */
    public suspend fun getConfigurationProfile(
        applicationId: String,
        configurationProfileId: String,
        tags: Map<String, String>? = null,
    ): GetConfigurationProfileResult {
        val argument = GetConfigurationProfilePlainArgs(
            applicationId = applicationId,
            configurationProfileId = configurationProfileId,
            tags = tags,
        )
        return getConfigurationProfileResultToKotlin(getConfigurationProfilePlain(argument.toJava()).await())
    }

    /**
     * @see [getConfigurationProfile].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;appconfig&#46;kotlin&#46;inputs&#46;GetConfigurationProfilePlainArgs].
     * @return A collection of values returned by getConfigurationProfile.
     */
    public suspend
    fun getConfigurationProfile(argument: suspend GetConfigurationProfilePlainArgsBuilder.() -> Unit):
        GetConfigurationProfileResult {
        val builder = GetConfigurationProfilePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigurationProfileResultToKotlin(getConfigurationProfilePlain(builtArgument.toJava()).await())
    }

    /**
     * Provides access to all Configuration Properties for an AppConfig Application. This will allow you to pass Configuration
     * Profile IDs to another resource.
     * ## Example Usage
     * ### Basic Usage
     * No Java example available.
     * @param argument A collection of arguments for invoking getConfigurationProfiles.
     * @return A collection of values returned by getConfigurationProfiles.
     */
    public suspend fun getConfigurationProfiles(argument: GetConfigurationProfilesPlainArgs):
        GetConfigurationProfilesResult =
        getConfigurationProfilesResultToKotlin(getConfigurationProfilesPlain(argument.toJava()).await())

    /**
     * @see [getConfigurationProfiles].
     * @param applicationId ID of the AppConfig Application.
     * @return A collection of values returned by getConfigurationProfiles.
     */
    public suspend fun getConfigurationProfiles(applicationId: String):
        GetConfigurationProfilesResult {
        val argument = GetConfigurationProfilesPlainArgs(
            applicationId = applicationId,
        )
        return getConfigurationProfilesResultToKotlin(getConfigurationProfilesPlain(argument.toJava()).await())
    }

    /**
     * @see [getConfigurationProfiles].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;appconfig&#46;kotlin&#46;inputs&#46;GetConfigurationProfilesPlainArgs].
     * @return A collection of values returned by getConfigurationProfiles.
     */
    public suspend
    fun getConfigurationProfiles(argument: suspend GetConfigurationProfilesPlainArgsBuilder.() -> Unit):
        GetConfigurationProfilesResult {
        val builder = GetConfigurationProfilesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigurationProfilesResultToKotlin(getConfigurationProfilesPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides access to an AppConfig Environment.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.appconfig.AppconfigFunctions;
     * import com.pulumi.aws.appconfig.inputs.GetEnvironmentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AppconfigFunctions.getEnvironment(GetEnvironmentArgs.builder()
     *             .applicationId("b5d5gpj")
     *             .environmentId("qrbb1c1")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getEnvironment.
     * @return A collection of values returned by getEnvironment.
     */
    public suspend fun getEnvironment(argument: GetEnvironmentPlainArgs): GetEnvironmentResult =
        getEnvironmentResultToKotlin(getEnvironmentPlain(argument.toJava()).await())

    /**
     * @see [getEnvironment].
     * @param applicationId ID of the AppConfig Application to which this Environment belongs.
     * @param environmentId ID of the AppConfig Environment.
     * @param tags Map of tags for the resource.
     * @return A collection of values returned by getEnvironment.
     */
    public suspend fun getEnvironment(
        applicationId: String,
        environmentId: String,
        tags: Map<String, String>? = null,
    ): GetEnvironmentResult {
        val argument = GetEnvironmentPlainArgs(
            applicationId = applicationId,
            environmentId = environmentId,
            tags = tags,
        )
        return getEnvironmentResultToKotlin(getEnvironmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getEnvironment].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;appconfig&#46;kotlin&#46;inputs&#46;GetEnvironmentPlainArgs].
     * @return A collection of values returned by getEnvironment.
     */
    public suspend fun getEnvironment(argument: suspend GetEnvironmentPlainArgsBuilder.() -> Unit):
        GetEnvironmentResult {
        val builder = GetEnvironmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEnvironmentResultToKotlin(getEnvironmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides access to all Environments for an AppConfig Application. This will allow you to pass Environment IDs to another
     * resource.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.appconfig.AppconfigFunctions;
     * import com.pulumi.aws.appconfig.inputs.GetEnvironmentsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AppconfigFunctions.getEnvironments(GetEnvironmentsArgs.builder()
     *             .applicationId("a1d3rpe")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getEnvironments.
     * @return A collection of values returned by getEnvironments.
     */
    public suspend fun getEnvironments(argument: GetEnvironmentsPlainArgs): GetEnvironmentsResult =
        getEnvironmentsResultToKotlin(getEnvironmentsPlain(argument.toJava()).await())

    /**
     * @see [getEnvironments].
     * @param applicationId ID of the AppConfig Application.
     * @return A collection of values returned by getEnvironments.
     */
    public suspend fun getEnvironments(applicationId: String): GetEnvironmentsResult {
        val argument = GetEnvironmentsPlainArgs(
            applicationId = applicationId,
        )
        return getEnvironmentsResultToKotlin(getEnvironmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getEnvironments].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;appconfig&#46;kotlin&#46;inputs&#46;GetEnvironmentsPlainArgs].
     * @return A collection of values returned by getEnvironments.
     */
    public suspend fun getEnvironments(argument: suspend GetEnvironmentsPlainArgsBuilder.() -> Unit):
        GetEnvironmentsResult {
        val builder = GetEnvironmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEnvironmentsResultToKotlin(getEnvironmentsPlain(builtArgument.toJava()).await())
    }
}
