@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin

import com.pulumi.aws.appconfig.DeploymentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AppConfig Deployment resource for an `aws.appconfig.Application` resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appconfig.Deployment;
 * import com.pulumi.aws.appconfig.DeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Deployment("example", DeploymentArgs.builder()
 *             .applicationId(aws_appconfig_application.example().id())
 *             .configurationProfileId(aws_appconfig_configuration_profile.example().configuration_profile_id())
 *             .configurationVersion(aws_appconfig_hosted_configuration_version.example().version_number())
 *             .deploymentStrategyId(aws_appconfig_deployment_strategy.example().id())
 *             .description("My example deployment")
 *             .environmentId(aws_appconfig_environment.example().environment_id())
 *             .tags(Map.of("Type", "AppConfig Deployment"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AppConfig Deployments using the application ID, environment ID, and deployment number separated by a slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:appconfig/deployment:Deployment example 71abcde/11xxxxx/1
 * ```
 * @property applicationId Application ID. Must be between 4 and 7 characters in length.
 * @property configurationProfileId Configuration profile ID. Must be between 4 and 7 characters in length.
 * @property configurationVersion Configuration version to deploy. Can be at most 1024 characters.
 * @property deploymentStrategyId Deployment strategy ID or name of a predefined deployment strategy. See [Predefined Deployment Strategies](https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-deployment-strategy.html#appconfig-creating-deployment-strategy-predefined) for more details.
 * @property description Description of the deployment. Can be at most 1024 characters.
 * @property environmentId Environment ID. Must be between 4 and 7 characters in length.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DeploymentArgs(
    public val applicationId: Output<String>? = null,
    public val configurationProfileId: Output<String>? = null,
    public val configurationVersion: Output<String>? = null,
    public val deploymentStrategyId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val environmentId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appconfig.DeploymentArgs> {
    override fun toJava(): com.pulumi.aws.appconfig.DeploymentArgs =
        com.pulumi.aws.appconfig.DeploymentArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .configurationProfileId(configurationProfileId?.applyValue({ args0 -> args0 }))
            .configurationVersion(configurationVersion?.applyValue({ args0 -> args0 }))
            .deploymentStrategyId(deploymentStrategyId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DeploymentArgs].
 */
@PulumiTagMarker
public class DeploymentArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var configurationProfileId: Output<String>? = null

    private var configurationVersion: Output<String>? = null

    private var deploymentStrategyId: Output<String>? = null

    private var description: Output<String>? = null

    private var environmentId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Application ID. Must be between 4 and 7 characters in length.
     */
    @JvmName("bkrtefpamaosbmiy")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value Configuration profile ID. Must be between 4 and 7 characters in length.
     */
    @JvmName("skjjimofyywfxuyk")
    public suspend fun configurationProfileId(`value`: Output<String>) {
        this.configurationProfileId = value
    }

    /**
     * @param value Configuration version to deploy. Can be at most 1024 characters.
     */
    @JvmName("umvfukdjugccirtc")
    public suspend fun configurationVersion(`value`: Output<String>) {
        this.configurationVersion = value
    }

    /**
     * @param value Deployment strategy ID or name of a predefined deployment strategy. See [Predefined Deployment Strategies](https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-deployment-strategy.html#appconfig-creating-deployment-strategy-predefined) for more details.
     */
    @JvmName("hmfynebyfirtmrhu")
    public suspend fun deploymentStrategyId(`value`: Output<String>) {
        this.deploymentStrategyId = value
    }

    /**
     * @param value Description of the deployment. Can be at most 1024 characters.
     */
    @JvmName("jmwyflkrsvtmwcrg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Environment ID. Must be between 4 and 7 characters in length.
     */
    @JvmName("fecequpqeltqpcsi")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xgadduguotnsploo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Application ID. Must be between 4 and 7 characters in length.
     */
    @JvmName("sruqgcyhlkjwmufs")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value Configuration profile ID. Must be between 4 and 7 characters in length.
     */
    @JvmName("ddwyvqvvejrikxti")
    public suspend fun configurationProfileId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationProfileId = mapped
    }

    /**
     * @param value Configuration version to deploy. Can be at most 1024 characters.
     */
    @JvmName("ypyrsjixkgjhwwjd")
    public suspend fun configurationVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationVersion = mapped
    }

    /**
     * @param value Deployment strategy ID or name of a predefined deployment strategy. See [Predefined Deployment Strategies](https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-deployment-strategy.html#appconfig-creating-deployment-strategy-predefined) for more details.
     */
    @JvmName("lhbuwcvaqxhpdyfe")
    public suspend fun deploymentStrategyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentStrategyId = mapped
    }

    /**
     * @param value Description of the deployment. Can be at most 1024 characters.
     */
    @JvmName("hxkqbjbuwssnhqha")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Environment ID. Must be between 4 and 7 characters in length.
     */
    @JvmName("twrqokkswwqhvpqr")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mvgeyhqguegtrcck")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ccyxhqnjddkmpqis")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DeploymentArgs = DeploymentArgs(
        applicationId = applicationId,
        configurationProfileId = configurationProfileId,
        configurationVersion = configurationVersion,
        deploymentStrategyId = deploymentStrategyId,
        description = description,
        environmentId = environmentId,
        tags = tags,
    )
}
