@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin

import com.pulumi.aws.appconfig.DeploymentStrategyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AppConfig Deployment Strategy resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appconfig.DeploymentStrategy;
 * import com.pulumi.aws.appconfig.DeploymentStrategyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DeploymentStrategy("example", DeploymentStrategyArgs.builder()
 *             .deploymentDurationInMinutes(3)
 *             .description("Example Deployment Strategy")
 *             .finalBakeTimeInMinutes(4)
 *             .growthFactor(10)
 *             .growthType("LINEAR")
 *             .replicateTo("NONE")
 *             .tags(Map.of("Type", "AppConfig Deployment Strategy"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AppConfig Deployment Strategies using their deployment strategy ID. For example:
 * ```sh
 *  $ pulumi import aws:appconfig/deploymentStrategy:DeploymentStrategy example 11xxxxx
 * ```
 * @property deploymentDurationInMinutes Total amount of time for a deployment to last. Minimum value of 0, maximum value of 1440.
 * @property description Description of the deployment strategy. Can be at most 1024 characters.
 * @property finalBakeTimeInMinutes Amount of time AWS AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic roll back. Minimum value of 0, maximum value of 1440.
 * @property growthFactor Percentage of targets to receive a deployed configuration during each interval. Minimum value of 1.0, maximum value of 100.0.
 * @property growthType Algorithm used to define how percentage grows over time. Valid value: `LINEAR` and `EXPONENTIAL`. Defaults to `LINEAR`.
 * @property name Name for the deployment strategy. Must be between 1 and 64 characters in length.
 * @property replicateTo Where to save the deployment strategy. Valid values: `NONE` and `SSM_DOCUMENT`.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DeploymentStrategyArgs(
    public val deploymentDurationInMinutes: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val finalBakeTimeInMinutes: Output<Int>? = null,
    public val growthFactor: Output<Double>? = null,
    public val growthType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val replicateTo: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appconfig.DeploymentStrategyArgs> {
    override fun toJava(): com.pulumi.aws.appconfig.DeploymentStrategyArgs =
        com.pulumi.aws.appconfig.DeploymentStrategyArgs.builder()
            .deploymentDurationInMinutes(deploymentDurationInMinutes?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .finalBakeTimeInMinutes(finalBakeTimeInMinutes?.applyValue({ args0 -> args0 }))
            .growthFactor(growthFactor?.applyValue({ args0 -> args0 }))
            .growthType(growthType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .replicateTo(replicateTo?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DeploymentStrategyArgs].
 */
@PulumiTagMarker
public class DeploymentStrategyArgsBuilder internal constructor() {
    private var deploymentDurationInMinutes: Output<Int>? = null

    private var description: Output<String>? = null

    private var finalBakeTimeInMinutes: Output<Int>? = null

    private var growthFactor: Output<Double>? = null

    private var growthType: Output<String>? = null

    private var name: Output<String>? = null

    private var replicateTo: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Total amount of time for a deployment to last. Minimum value of 0, maximum value of 1440.
     */
    @JvmName("gacujedvqgyrgyhv")
    public suspend fun deploymentDurationInMinutes(`value`: Output<Int>) {
        this.deploymentDurationInMinutes = value
    }

    /**
     * @param value Description of the deployment strategy. Can be at most 1024 characters.
     */
    @JvmName("cxmsdojutkknfblc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Amount of time AWS AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic roll back. Minimum value of 0, maximum value of 1440.
     */
    @JvmName("daiwyswgyhbanqcp")
    public suspend fun finalBakeTimeInMinutes(`value`: Output<Int>) {
        this.finalBakeTimeInMinutes = value
    }

    /**
     * @param value Percentage of targets to receive a deployed configuration during each interval. Minimum value of 1.0, maximum value of 100.0.
     */
    @JvmName("fjfngallmdrcxnyj")
    public suspend fun growthFactor(`value`: Output<Double>) {
        this.growthFactor = value
    }

    /**
     * @param value Algorithm used to define how percentage grows over time. Valid value: `LINEAR` and `EXPONENTIAL`. Defaults to `LINEAR`.
     */
    @JvmName("fkxtoakcwwacjkdo")
    public suspend fun growthType(`value`: Output<String>) {
        this.growthType = value
    }

    /**
     * @param value Name for the deployment strategy. Must be between 1 and 64 characters in length.
     */
    @JvmName("kmpypnlciokppjwk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Where to save the deployment strategy. Valid values: `NONE` and `SSM_DOCUMENT`.
     */
    @JvmName("xevwgqclmfnnafle")
    public suspend fun replicateTo(`value`: Output<String>) {
        this.replicateTo = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("oomsibpvhekawwix")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Total amount of time for a deployment to last. Minimum value of 0, maximum value of 1440.
     */
    @JvmName("cnbebybrnrthdqqg")
    public suspend fun deploymentDurationInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentDurationInMinutes = mapped
    }

    /**
     * @param value Description of the deployment strategy. Can be at most 1024 characters.
     */
    @JvmName("xpdrnpovjagwekch")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Amount of time AWS AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic roll back. Minimum value of 0, maximum value of 1440.
     */
    @JvmName("ppobrdvjogsftdpo")
    public suspend fun finalBakeTimeInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.finalBakeTimeInMinutes = mapped
    }

    /**
     * @param value Percentage of targets to receive a deployed configuration during each interval. Minimum value of 1.0, maximum value of 100.0.
     */
    @JvmName("qkxphhjvwbchlcuu")
    public suspend fun growthFactor(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.growthFactor = mapped
    }

    /**
     * @param value Algorithm used to define how percentage grows over time. Valid value: `LINEAR` and `EXPONENTIAL`. Defaults to `LINEAR`.
     */
    @JvmName("pkkyqhoodmrukgoa")
    public suspend fun growthType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.growthType = mapped
    }

    /**
     * @param value Name for the deployment strategy. Must be between 1 and 64 characters in length.
     */
    @JvmName("pwjmbifjgmrebljy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Where to save the deployment strategy. Valid values: `NONE` and `SSM_DOCUMENT`.
     */
    @JvmName("qqnqeqmqktjiifjv")
    public suspend fun replicateTo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicateTo = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cekgudbvuorqbmua")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gjfyyqcgaecbugty")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DeploymentStrategyArgs = DeploymentStrategyArgs(
        deploymentDurationInMinutes = deploymentDurationInMinutes,
        description = description,
        finalBakeTimeInMinutes = finalBakeTimeInMinutes,
        growthFactor = growthFactor,
        growthType = growthType,
        name = name,
        replicateTo = replicateTo,
        tags = tags,
    )
}
