@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin

import com.pulumi.aws.appconfig.kotlin.outputs.EnvironmentMonitor
import com.pulumi.aws.appconfig.kotlin.outputs.EnvironmentMonitor.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Environment].
 */
@PulumiTagMarker
public class EnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnvironmentArgs = EnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnvironmentArgsBuilder.() -> Unit) {
        val builder = EnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Environment {
        val builtJavaResource = com.pulumi.aws.appconfig.Environment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Environment(builtJavaResource)
    }
}

/**
 * Provides an AppConfig Environment resource for an `aws.appconfig.Application` resource. One or more environments can be defined for an application.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appconfig.Application;
 * import com.pulumi.aws.appconfig.ApplicationArgs;
 * import com.pulumi.aws.appconfig.Environment;
 * import com.pulumi.aws.appconfig.EnvironmentArgs;
 * import com.pulumi.aws.appconfig.inputs.EnvironmentMonitorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleApplication = new Application("exampleApplication", ApplicationArgs.builder()
 *             .description("Example AppConfig Application")
 *             .tags(Map.of("Type", "AppConfig Application"))
 *             .build());
 *         var exampleEnvironment = new Environment("exampleEnvironment", EnvironmentArgs.builder()
 *             .description("Example AppConfig Environment")
 *             .applicationId(exampleApplication.id())
 *             .monitors(EnvironmentMonitorArgs.builder()
 *                 .alarmArn(aws_cloudwatch_metric_alarm.example().arn())
 *                 .alarmRoleArn(aws_iam_role.example().arn())
 *                 .build())
 *             .tags(Map.of("Type", "AppConfig Environment"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AppConfig Environments using the environment ID and application ID separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:appconfig/environment:Environment example 71abcde:11xxxxx
 * ```
 *
 */
public class Environment internal constructor(
    override val javaResource: com.pulumi.aws.appconfig.Environment,
) : KotlinCustomResource(javaResource, EnvironmentMapper) {
    /**
     * AppConfig application ID. Must be between 4 and 7 characters in length.
     */
    public val applicationId: Output<String>
        get() = javaResource.applicationId().applyValue({ args0 -> args0 })

    /**
     * ARN of the AppConfig Environment.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of the environment. Can be at most 1024 characters.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * AppConfig environment ID.
     */
    public val environmentId: Output<String>
        get() = javaResource.environmentId().applyValue({ args0 -> args0 })

    /**
     * Set of Amazon CloudWatch alarms to monitor during the deployment process. Maximum of 5. See Monitor below for more details.
     */
    public val monitors: Output<List<EnvironmentMonitor>>?
        get() = javaResource.monitors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Name for the environment. Must be between 1 and 64 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * State of the environment. Possible values are `READY_FOR_DEPLOYMENT`, `DEPLOYING`, `ROLLING_BACK`
     * or `ROLLED_BACK`.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object EnvironmentMapper : ResourceMapper<Environment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appconfig.Environment::class == javaResource::class

    override fun map(javaResource: Resource): Environment = Environment(
        javaResource as
            com.pulumi.aws.appconfig.Environment,
    )
}

/**
 * @see [Environment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Environment].
 */
public suspend fun environment(name: String, block: suspend EnvironmentResourceBuilder.() -> Unit):
    Environment {
    val builder = EnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Environment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun environment(name: String): Environment {
    val builder = EnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
