@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin

import com.pulumi.aws.appconfig.EnvironmentArgs.builder
import com.pulumi.aws.appconfig.kotlin.inputs.EnvironmentMonitorArgs
import com.pulumi.aws.appconfig.kotlin.inputs.EnvironmentMonitorArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AppConfig Environment resource for an `aws.appconfig.Application` resource. One or more environments can be defined for an application.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appconfig.Application;
 * import com.pulumi.aws.appconfig.ApplicationArgs;
 * import com.pulumi.aws.appconfig.Environment;
 * import com.pulumi.aws.appconfig.EnvironmentArgs;
 * import com.pulumi.aws.appconfig.inputs.EnvironmentMonitorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleApplication = new Application("exampleApplication", ApplicationArgs.builder()
 *             .description("Example AppConfig Application")
 *             .tags(Map.of("Type", "AppConfig Application"))
 *             .build());
 *         var exampleEnvironment = new Environment("exampleEnvironment", EnvironmentArgs.builder()
 *             .description("Example AppConfig Environment")
 *             .applicationId(exampleApplication.id())
 *             .monitors(EnvironmentMonitorArgs.builder()
 *                 .alarmArn(aws_cloudwatch_metric_alarm.example().arn())
 *                 .alarmRoleArn(aws_iam_role.example().arn())
 *                 .build())
 *             .tags(Map.of("Type", "AppConfig Environment"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AppConfig Environments using the environment ID and application ID separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:appconfig/environment:Environment example 71abcde:11xxxxx
 * ```
 * @property applicationId AppConfig application ID. Must be between 4 and 7 characters in length.
 * @property description Description of the environment. Can be at most 1024 characters.
 * @property monitors Set of Amazon CloudWatch alarms to monitor during the deployment process. Maximum of 5. See Monitor below for more details.
 * @property name Name for the environment. Must be between 1 and 64 characters in length.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class EnvironmentArgs(
    public val applicationId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val monitors: Output<List<EnvironmentMonitorArgs>>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appconfig.EnvironmentArgs> {
    override fun toJava(): com.pulumi.aws.appconfig.EnvironmentArgs =
        com.pulumi.aws.appconfig.EnvironmentArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .monitors(
                monitors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EnvironmentArgs].
 */
@PulumiTagMarker
public class EnvironmentArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var description: Output<String>? = null

    private var monitors: Output<List<EnvironmentMonitorArgs>>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value AppConfig application ID. Must be between 4 and 7 characters in length.
     */
    @JvmName("fhpmqbnmwnplwopj")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value Description of the environment. Can be at most 1024 characters.
     */
    @JvmName("gkcpcfiosdxymoim")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Set of Amazon CloudWatch alarms to monitor during the deployment process. Maximum of 5. See Monitor below for more details.
     */
    @JvmName("hrkxultxwqdwsjgd")
    public suspend fun monitors(`value`: Output<List<EnvironmentMonitorArgs>>) {
        this.monitors = value
    }

    @JvmName("eummvpdolrkcpklo")
    public suspend fun monitors(vararg values: Output<EnvironmentMonitorArgs>) {
        this.monitors = Output.all(values.asList())
    }

    /**
     * @param values Set of Amazon CloudWatch alarms to monitor during the deployment process. Maximum of 5. See Monitor below for more details.
     */
    @JvmName("mhwcehyfnemdfcgp")
    public suspend fun monitors(values: List<Output<EnvironmentMonitorArgs>>) {
        this.monitors = Output.all(values)
    }

    /**
     * @param value Name for the environment. Must be between 1 and 64 characters in length.
     */
    @JvmName("sjyumixsgfuvssbh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gmowlcmlsjvbkocv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value AppConfig application ID. Must be between 4 and 7 characters in length.
     */
    @JvmName("oiyrbyhaktsjksrs")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value Description of the environment. Can be at most 1024 characters.
     */
    @JvmName("pajyhyqlhpppyvba")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Set of Amazon CloudWatch alarms to monitor during the deployment process. Maximum of 5. See Monitor below for more details.
     */
    @JvmName("lkpybyanysrkqqym")
    public suspend fun monitors(`value`: List<EnvironmentMonitorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitors = mapped
    }

    /**
     * @param argument Set of Amazon CloudWatch alarms to monitor during the deployment process. Maximum of 5. See Monitor below for more details.
     */
    @JvmName("plrtrosmowqnjfij")
    public suspend fun monitors(argument: List<suspend EnvironmentMonitorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EnvironmentMonitorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.monitors = mapped
    }

    /**
     * @param argument Set of Amazon CloudWatch alarms to monitor during the deployment process. Maximum of 5. See Monitor below for more details.
     */
    @JvmName("iusejffkiphkgpfy")
    public suspend fun monitors(vararg argument: suspend EnvironmentMonitorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EnvironmentMonitorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.monitors = mapped
    }

    /**
     * @param argument Set of Amazon CloudWatch alarms to monitor during the deployment process. Maximum of 5. See Monitor below for more details.
     */
    @JvmName("rjtwghlhgedefsqr")
    public suspend fun monitors(argument: suspend EnvironmentMonitorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EnvironmentMonitorArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.monitors = mapped
    }

    /**
     * @param values Set of Amazon CloudWatch alarms to monitor during the deployment process. Maximum of 5. See Monitor below for more details.
     */
    @JvmName("bmuipacxewtwrxyc")
    public suspend fun monitors(vararg values: EnvironmentMonitorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monitors = mapped
    }

    /**
     * @param value Name for the environment. Must be between 1 and 64 characters in length.
     */
    @JvmName("rvtaiyqchtyovdmn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("idxrbkhmkeaydosv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("akdfdiesqxsnrexi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EnvironmentArgs = EnvironmentArgs(
        applicationId = applicationId,
        description = description,
        monitors = monitors,
        name = name,
        tags = tags,
    )
}
