@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin

import com.pulumi.aws.appconfig.EventIntegrationArgs.builder
import com.pulumi.aws.appconfig.kotlin.inputs.EventIntegrationEventFilterArgs
import com.pulumi.aws.appconfig.kotlin.inputs.EventIntegrationEventFilterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon AppIntegrations Event Integration resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appconfig.EventIntegration;
 * import com.pulumi.aws.appconfig.EventIntegrationArgs;
 * import com.pulumi.aws.appconfig.inputs.EventIntegrationEventFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventIntegration("example", EventIntegrationArgs.builder()
 *             .description("Example Description")
 *             .eventFilter(EventIntegrationEventFilterArgs.builder()
 *                 .source("aws.partner/examplepartner.com")
 *                 .build())
 *             .eventbridgeBus("default")
 *             .tags(Map.of("Name", "Example Event Integration"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amazon AppIntegrations Event Integrations using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:appconfig/eventIntegration:EventIntegration example example-name
 * ```
 * @property description Description of the Event Integration.
 * @property eventFilter Block that defines the configuration information for the event filter. The Event Filter block is documented below.
 * @property eventbridgeBus EventBridge bus.
 * @property name Name of the Event Integration.
 * @property tags Tags to apply to the Event Integration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class EventIntegrationArgs(
    public val description: Output<String>? = null,
    public val eventFilter: Output<EventIntegrationEventFilterArgs>? = null,
    public val eventbridgeBus: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appconfig.EventIntegrationArgs> {
    override fun toJava(): com.pulumi.aws.appconfig.EventIntegrationArgs =
        com.pulumi.aws.appconfig.EventIntegrationArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .eventFilter(eventFilter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .eventbridgeBus(eventbridgeBus?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EventIntegrationArgs].
 */
@PulumiTagMarker
public class EventIntegrationArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var eventFilter: Output<EventIntegrationEventFilterArgs>? = null

    private var eventbridgeBus: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description of the Event Integration.
     */
    @JvmName("tdjnobnsbejldimq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Block that defines the configuration information for the event filter. The Event Filter block is documented below.
     */
    @JvmName("pstilfxagyvpmceb")
    public suspend fun eventFilter(`value`: Output<EventIntegrationEventFilterArgs>) {
        this.eventFilter = value
    }

    /**
     * @param value EventBridge bus.
     */
    @JvmName("gpqowoqsyqhkfhol")
    public suspend fun eventbridgeBus(`value`: Output<String>) {
        this.eventbridgeBus = value
    }

    /**
     * @param value Name of the Event Integration.
     */
    @JvmName("qkgkkhyutiexnufq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Tags to apply to the Event Integration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("unvblubvkokddgtg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description of the Event Integration.
     */
    @JvmName("snwvsskunwhdjitj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Block that defines the configuration information for the event filter. The Event Filter block is documented below.
     */
    @JvmName("uoxxmwbbmqtoicbd")
    public suspend fun eventFilter(`value`: EventIntegrationEventFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventFilter = mapped
    }

    /**
     * @param argument Block that defines the configuration information for the event filter. The Event Filter block is documented below.
     */
    @JvmName("obxbdxqygxjsufjx")
    public suspend
    fun eventFilter(argument: suspend EventIntegrationEventFilterArgsBuilder.() -> Unit) {
        val toBeMapped = EventIntegrationEventFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.eventFilter = mapped
    }

    /**
     * @param value EventBridge bus.
     */
    @JvmName("owjtoqqttmmolngb")
    public suspend fun eventbridgeBus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventbridgeBus = mapped
    }

    /**
     * @param value Name of the Event Integration.
     */
    @JvmName("viwyrevyopnvuspt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Tags to apply to the Event Integration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("udkvltrxjlhecbxv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the Event Integration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("irabmipsyrhmkmxv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EventIntegrationArgs = EventIntegrationArgs(
        description = description,
        eventFilter = eventFilter,
        eventbridgeBus = eventbridgeBus,
        name = name,
        tags = tags,
    )
}
