@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin

import com.pulumi.aws.appconfig.ExtensionArgs.builder
import com.pulumi.aws.appconfig.kotlin.inputs.ExtensionActionPointArgs
import com.pulumi.aws.appconfig.kotlin.inputs.ExtensionActionPointArgsBuilder
import com.pulumi.aws.appconfig.kotlin.inputs.ExtensionParameterArgs
import com.pulumi.aws.appconfig.kotlin.inputs.ExtensionParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AppConfig Extension resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.appconfig.Extension;
 * import com.pulumi.aws.appconfig.ExtensionArgs;
 * import com.pulumi.aws.appconfig.inputs.ExtensionActionPointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testTopic = new Topic("testTopic");
 *         final var testPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("appconfig.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var testRole = new Role("testRole", RoleArgs.builder()
 *             .assumeRolePolicy(testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var testExtension = new Extension("testExtension", ExtensionArgs.builder()
 *             .description("test description")
 *             .actionPoints(ExtensionActionPointArgs.builder()
 *                 .point("ON_DEPLOYMENT_COMPLETE")
 *                 .actions(ExtensionActionPointActionArgs.builder()
 *                     .name("test")
 *                     .roleArn(testRole.arn())
 *                     .uri(testTopic.arn())
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Type", "AppConfig Extension"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AppConfig Extensions using their extension ID. For example:
 * ```sh
 *  $ pulumi import aws:appconfig/extension:Extension example 71rxuzt
 * ```
 * @property actionPoints The action points defined in the extension. Detailed below.
 * @property description Information about the extension.
 * @property name A name for the extension. Each extension name in your account must be unique. Extension versions use the same name.
 * @property parameters The parameters accepted by the extension. You specify parameter values when you associate the extension to an AppConfig resource by using the CreateExtensionAssociation API action. For Lambda extension actions, these parameters are included in the Lambda request object. Detailed below.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ExtensionArgs(
    public val actionPoints: Output<List<ExtensionActionPointArgs>>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val parameters: Output<List<ExtensionParameterArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appconfig.ExtensionArgs> {
    override fun toJava(): com.pulumi.aws.appconfig.ExtensionArgs =
        com.pulumi.aws.appconfig.ExtensionArgs.builder()
            .actionPoints(
                actionPoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ExtensionArgs].
 */
@PulumiTagMarker
public class ExtensionArgsBuilder internal constructor() {
    private var actionPoints: Output<List<ExtensionActionPointArgs>>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var parameters: Output<List<ExtensionParameterArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The action points defined in the extension. Detailed below.
     */
    @JvmName("teifhqbvmdwitvnr")
    public suspend fun actionPoints(`value`: Output<List<ExtensionActionPointArgs>>) {
        this.actionPoints = value
    }

    @JvmName("mkpffeookheeotgi")
    public suspend fun actionPoints(vararg values: Output<ExtensionActionPointArgs>) {
        this.actionPoints = Output.all(values.asList())
    }

    /**
     * @param values The action points defined in the extension. Detailed below.
     */
    @JvmName("afbxaakucvhpaqnn")
    public suspend fun actionPoints(values: List<Output<ExtensionActionPointArgs>>) {
        this.actionPoints = Output.all(values)
    }

    /**
     * @param value Information about the extension.
     */
    @JvmName("ryqsxdymimenkkju")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A name for the extension. Each extension name in your account must be unique. Extension versions use the same name.
     */
    @JvmName("codpfchrjvxiksfb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The parameters accepted by the extension. You specify parameter values when you associate the extension to an AppConfig resource by using the CreateExtensionAssociation API action. For Lambda extension actions, these parameters are included in the Lambda request object. Detailed below.
     */
    @JvmName("rwujaqqnryocseif")
    public suspend fun parameters(`value`: Output<List<ExtensionParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("fatkjxmtseipjsey")
    public suspend fun parameters(vararg values: Output<ExtensionParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values The parameters accepted by the extension. You specify parameter values when you associate the extension to an AppConfig resource by using the CreateExtensionAssociation API action. For Lambda extension actions, these parameters are included in the Lambda request object. Detailed below.
     */
    @JvmName("btefcnxyboswwvxg")
    public suspend fun parameters(values: List<Output<ExtensionParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("anlddgvoosttubim")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The action points defined in the extension. Detailed below.
     */
    @JvmName("uwfdbkxlvhoxfpts")
    public suspend fun actionPoints(`value`: List<ExtensionActionPointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionPoints = mapped
    }

    /**
     * @param argument The action points defined in the extension. Detailed below.
     */
    @JvmName("okholwunidvfdxlx")
    public suspend
    fun actionPoints(argument: List<suspend ExtensionActionPointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExtensionActionPointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actionPoints = mapped
    }

    /**
     * @param argument The action points defined in the extension. Detailed below.
     */
    @JvmName("soxmniywnmuhxexp")
    public suspend fun actionPoints(
        vararg
        argument: suspend ExtensionActionPointArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ExtensionActionPointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actionPoints = mapped
    }

    /**
     * @param argument The action points defined in the extension. Detailed below.
     */
    @JvmName("greyoaehwafwxhhd")
    public suspend fun actionPoints(argument: suspend ExtensionActionPointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ExtensionActionPointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.actionPoints = mapped
    }

    /**
     * @param values The action points defined in the extension. Detailed below.
     */
    @JvmName("tvpublrqbynqbjac")
    public suspend fun actionPoints(vararg values: ExtensionActionPointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionPoints = mapped
    }

    /**
     * @param value Information about the extension.
     */
    @JvmName("csmelnhnqwriaxek")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A name for the extension. Each extension name in your account must be unique. Extension versions use the same name.
     */
    @JvmName("jfwryqwmykglvlpb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The parameters accepted by the extension. You specify parameter values when you associate the extension to an AppConfig resource by using the CreateExtensionAssociation API action. For Lambda extension actions, these parameters are included in the Lambda request object. Detailed below.
     */
    @JvmName("avfvltsjbeedxtxo")
    public suspend fun parameters(`value`: List<ExtensionParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameters accepted by the extension. You specify parameter values when you associate the extension to an AppConfig resource by using the CreateExtensionAssociation API action. For Lambda extension actions, these parameters are included in the Lambda request object. Detailed below.
     */
    @JvmName("udqxdvbewxtmxpla")
    public suspend fun parameters(argument: List<suspend ExtensionParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExtensionParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters accepted by the extension. You specify parameter values when you associate the extension to an AppConfig resource by using the CreateExtensionAssociation API action. For Lambda extension actions, these parameters are included in the Lambda request object. Detailed below.
     */
    @JvmName("yattawcqbxwnowkh")
    public suspend fun parameters(vararg argument: suspend ExtensionParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExtensionParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters accepted by the extension. You specify parameter values when you associate the extension to an AppConfig resource by using the CreateExtensionAssociation API action. For Lambda extension actions, these parameters are included in the Lambda request object. Detailed below.
     */
    @JvmName("ymbruasjajxpsjlr")
    public suspend fun parameters(argument: suspend ExtensionParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ExtensionParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The parameters accepted by the extension. You specify parameter values when you associate the extension to an AppConfig resource by using the CreateExtensionAssociation API action. For Lambda extension actions, these parameters are included in the Lambda request object. Detailed below.
     */
    @JvmName("ukynkykqltwmribv")
    public suspend fun parameters(vararg values: ExtensionParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("janqfhluvvmwrdky")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jihqkmvygaldyuwc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ExtensionArgs = ExtensionArgs(
        actionPoints = actionPoints,
        description = description,
        name = name,
        parameters = parameters,
        tags = tags,
    )
}
