@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ExtensionAssociation].
 */
@PulumiTagMarker
public class ExtensionAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExtensionAssociationArgs = ExtensionAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExtensionAssociationArgsBuilder.() -> Unit) {
        val builder = ExtensionAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ExtensionAssociation {
        val builtJavaResource = com.pulumi.aws.appconfig.ExtensionAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ExtensionAssociation(builtJavaResource)
    }
}

/**
 * Associates an AppConfig Extension with a Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.appconfig.Extension;
 * import com.pulumi.aws.appconfig.ExtensionArgs;
 * import com.pulumi.aws.appconfig.inputs.ExtensionActionPointArgs;
 * import com.pulumi.aws.appconfig.Application;
 * import com.pulumi.aws.appconfig.ExtensionAssociation;
 * import com.pulumi.aws.appconfig.ExtensionAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testTopic = new Topic("testTopic");
 *         final var testPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("appconfig.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var testRole = new Role("testRole", RoleArgs.builder()
 *             .assumeRolePolicy(testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var testExtension = new Extension("testExtension", ExtensionArgs.builder()
 *             .description("test description")
 *             .actionPoints(ExtensionActionPointArgs.builder()
 *                 .point("ON_DEPLOYMENT_COMPLETE")
 *                 .actions(ExtensionActionPointActionArgs.builder()
 *                     .name("test")
 *                     .roleArn(testRole.arn())
 *                     .uri(testTopic.arn())
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Type", "AppConfig Extension"))
 *             .build());
 *         var testApplication = new Application("testApplication");
 *         var testExtensionAssociation = new ExtensionAssociation("testExtensionAssociation", ExtensionAssociationArgs.builder()
 *             .extensionArn(testExtension.arn())
 *             .resourceArn(testApplication.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AppConfig Extension Associations using their extension association ID. For example:
 * ```sh
 *  $ pulumi import aws:appconfig/extensionAssociation:ExtensionAssociation example 71rxuzt
 * ```
 *
 */
public class ExtensionAssociation internal constructor(
    override val javaResource: com.pulumi.aws.appconfig.ExtensionAssociation,
) : KotlinCustomResource(javaResource, ExtensionAssociationMapper) {
    /**
     * ARN of the AppConfig Extension Association.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ARN of the extension defined in the association.
     */
    public val extensionArn: Output<String>
        get() = javaResource.extensionArn().applyValue({ args0 -> args0 })

    /**
     * The version number for the extension defined in the association.
     */
    public val extensionVersion: Output<Int>
        get() = javaResource.extensionVersion().applyValue({ args0 -> args0 })

    /**
     * The parameter names and values defined for the association.
     */
    public val parameters: Output<Map<String, String>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The ARN of the application, configuration profile, or environment to associate with the extension.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })
}

public object ExtensionAssociationMapper : ResourceMapper<ExtensionAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appconfig.ExtensionAssociation::class == javaResource::class

    override fun map(javaResource: Resource): ExtensionAssociation = ExtensionAssociation(
        javaResource
            as com.pulumi.aws.appconfig.ExtensionAssociation,
    )
}

/**
 * @see [ExtensionAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ExtensionAssociation].
 */
public suspend fun extensionAssociation(
    name: String,
    block: suspend ExtensionAssociationResourceBuilder.() -> Unit,
): ExtensionAssociation {
    val builder = ExtensionAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ExtensionAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun extensionAssociation(name: String): ExtensionAssociation {
    val builder = ExtensionAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
