@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin

import com.pulumi.aws.appconfig.ExtensionAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Associates an AppConfig Extension with a Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.appconfig.Extension;
 * import com.pulumi.aws.appconfig.ExtensionArgs;
 * import com.pulumi.aws.appconfig.inputs.ExtensionActionPointArgs;
 * import com.pulumi.aws.appconfig.Application;
 * import com.pulumi.aws.appconfig.ExtensionAssociation;
 * import com.pulumi.aws.appconfig.ExtensionAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testTopic = new Topic("testTopic");
 *         final var testPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("appconfig.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var testRole = new Role("testRole", RoleArgs.builder()
 *             .assumeRolePolicy(testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var testExtension = new Extension("testExtension", ExtensionArgs.builder()
 *             .description("test description")
 *             .actionPoints(ExtensionActionPointArgs.builder()
 *                 .point("ON_DEPLOYMENT_COMPLETE")
 *                 .actions(ExtensionActionPointActionArgs.builder()
 *                     .name("test")
 *                     .roleArn(testRole.arn())
 *                     .uri(testTopic.arn())
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Type", "AppConfig Extension"))
 *             .build());
 *         var testApplication = new Application("testApplication");
 *         var testExtensionAssociation = new ExtensionAssociation("testExtensionAssociation", ExtensionAssociationArgs.builder()
 *             .extensionArn(testExtension.arn())
 *             .resourceArn(testApplication.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AppConfig Extension Associations using their extension association ID. For example:
 * ```sh
 *  $ pulumi import aws:appconfig/extensionAssociation:ExtensionAssociation example 71rxuzt
 * ```
 * @property extensionArn The ARN of the extension defined in the association.
 * @property parameters The parameter names and values defined for the association.
 * @property resourceArn The ARN of the application, configuration profile, or environment to associate with the extension.
 */
public data class ExtensionAssociationArgs(
    public val extensionArn: Output<String>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val resourceArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appconfig.ExtensionAssociationArgs> {
    override fun toJava(): com.pulumi.aws.appconfig.ExtensionAssociationArgs =
        com.pulumi.aws.appconfig.ExtensionAssociationArgs.builder()
            .extensionArn(extensionArn?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExtensionAssociationArgs].
 */
@PulumiTagMarker
public class ExtensionAssociationArgsBuilder internal constructor() {
    private var extensionArn: Output<String>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var resourceArn: Output<String>? = null

    /**
     * @param value The ARN of the extension defined in the association.
     */
    @JvmName("kawjcdjmktdqeywa")
    public suspend fun extensionArn(`value`: Output<String>) {
        this.extensionArn = value
    }

    /**
     * @param value The parameter names and values defined for the association.
     */
    @JvmName("ivfbgqdsprpehtds")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value The ARN of the application, configuration profile, or environment to associate with the extension.
     */
    @JvmName("ksgygfgnjuowtvta")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value The ARN of the extension defined in the association.
     */
    @JvmName("elyukqhxcqhoulym")
    public suspend fun extensionArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionArn = mapped
    }

    /**
     * @param value The parameter names and values defined for the association.
     */
    @JvmName("towbqksimqtvnaee")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values The parameter names and values defined for the association.
     */
    @JvmName("aycnteahdbqtemew")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The ARN of the application, configuration profile, or environment to associate with the extension.
     */
    @JvmName("fjoryaxclmpwudke")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    internal fun build(): ExtensionAssociationArgs = ExtensionAssociationArgs(
        extensionArn = extensionArn,
        parameters = parameters,
        resourceArn = resourceArn,
    )
}
