@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [HostedConfigurationVersion].
 */
@PulumiTagMarker
public class HostedConfigurationVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HostedConfigurationVersionArgs = HostedConfigurationVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HostedConfigurationVersionArgsBuilder.() -> Unit) {
        val builder = HostedConfigurationVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): HostedConfigurationVersion {
        val builtJavaResource =
            com.pulumi.aws.appconfig.HostedConfigurationVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HostedConfigurationVersion(builtJavaResource)
    }
}

/**
 * Provides an AppConfig Hosted Configuration Version resource.
 * ## Example Usage
 * ### Freeform
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appconfig.HostedConfigurationVersion;
 * import com.pulumi.aws.appconfig.HostedConfigurationVersionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HostedConfigurationVersion("example", HostedConfigurationVersionArgs.builder()
 *             .applicationId(aws_appconfig_application.example().id())
 *             .configurationProfileId(aws_appconfig_configuration_profile.example().configuration_profile_id())
 *             .description("Example Freeform Hosted Configuration Version")
 *             .contentType("application/json")
 *             .content(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("foo", "bar"),
 *                     jsonProperty("fruit", jsonArray(
 *                         "apple",
 *                         "pear",
 *                         "orange"
 *                     )),
 *                     jsonProperty("isThingEnabled", true)
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ### Feature Flags
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appconfig.HostedConfigurationVersion;
 * import com.pulumi.aws.appconfig.HostedConfigurationVersionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HostedConfigurationVersion("example", HostedConfigurationVersionArgs.builder()
 *             .applicationId(aws_appconfig_application.example().id())
 *             .configurationProfileId(aws_appconfig_configuration_profile.example().configuration_profile_id())
 *             .description("Example Feature Flag Configuration Version")
 *             .contentType("application/json")
 *             .content(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("flags", jsonObject(
 *                         jsonProperty("foo", jsonObject(
 *                             jsonProperty("name", "foo"),
 *                             jsonProperty("_deprecation", jsonObject(
 *                                 jsonProperty("status", "planned")
 *                             ))
 *                         )),
 *                         jsonProperty("bar", jsonObject(
 *                             jsonProperty("name", "bar"),
 *                             jsonProperty("attributes", jsonObject(
 *                                 jsonProperty("someAttribute", jsonObject(
 *                                     jsonProperty("constraints", jsonObject(
 *                                         jsonProperty("type", "string"),
 *                                         jsonProperty("required", true)
 *                                     ))
 *                                 )),
 *                                 jsonProperty("someOtherAttribute", jsonObject(
 *                                     jsonProperty("constraints", jsonObject(
 *                                         jsonProperty("type", "number"),
 *                                         jsonProperty("required", true)
 *                                     ))
 *                                 ))
 *                             ))
 *                         ))
 *                     )),
 *                     jsonProperty("values", jsonObject(
 *                         jsonProperty("foo", jsonObject(
 *                             jsonProperty("enabled", "true")
 *                         )),
 *                         jsonProperty("bar", jsonObject(
 *                             jsonProperty("enabled", "true"),
 *                             jsonProperty("someAttribute", "Hello World"),
 *                             jsonProperty("someOtherAttribute", 123)
 *                         ))
 *                     )),
 *                     jsonProperty("version", "1")
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AppConfig Hosted Configuration Versions using the application ID, configuration profile ID, and version number separated by a slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:appconfig/hostedConfigurationVersion:HostedConfigurationVersion example 71abcde/11xxxxx/2
 * ```
 *
 */
public class HostedConfigurationVersion internal constructor(
    override val javaResource: com.pulumi.aws.appconfig.HostedConfigurationVersion,
) : KotlinCustomResource(javaResource, HostedConfigurationVersionMapper) {
    /**
     * Application ID.
     */
    public val applicationId: Output<String>
        get() = javaResource.applicationId().applyValue({ args0 -> args0 })

    /**
     * ARN of the AppConfig  hosted configuration version.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Configuration profile ID.
     */
    public val configurationProfileId: Output<String>
        get() = javaResource.configurationProfileId().applyValue({ args0 -> args0 })

    /**
     * Content of the configuration or the configuration data.
     */
    public val content: Output<String>
        get() = javaResource.content().applyValue({ args0 -> args0 })

    /**
     * Standard MIME type describing the format of the configuration content. For more information, see [Content-Type](https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17).
     */
    public val contentType: Output<String>
        get() = javaResource.contentType().applyValue({ args0 -> args0 })

    /**
     * Description of the configuration.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Version number of the hosted configuration.
     */
    public val versionNumber: Output<Int>
        get() = javaResource.versionNumber().applyValue({ args0 -> args0 })
}

public object HostedConfigurationVersionMapper : ResourceMapper<HostedConfigurationVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appconfig.HostedConfigurationVersion::class == javaResource::class

    override fun map(javaResource: Resource): HostedConfigurationVersion =
        HostedConfigurationVersion(
            javaResource as
                com.pulumi.aws.appconfig.HostedConfigurationVersion,
        )
}

/**
 * @see [HostedConfigurationVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HostedConfigurationVersion].
 */
public suspend fun hostedConfigurationVersion(
    name: String,
    block: suspend HostedConfigurationVersionResourceBuilder.() -> Unit,
):
    HostedConfigurationVersion {
    val builder = HostedConfigurationVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HostedConfigurationVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hostedConfigurationVersion(name: String): HostedConfigurationVersion {
    val builder = HostedConfigurationVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
