@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin

import com.pulumi.aws.appconfig.HostedConfigurationVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AppConfig Hosted Configuration Version resource.
 * ## Example Usage
 * ### Freeform
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appconfig.HostedConfigurationVersion;
 * import com.pulumi.aws.appconfig.HostedConfigurationVersionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HostedConfigurationVersion("example", HostedConfigurationVersionArgs.builder()
 *             .applicationId(aws_appconfig_application.example().id())
 *             .configurationProfileId(aws_appconfig_configuration_profile.example().configuration_profile_id())
 *             .description("Example Freeform Hosted Configuration Version")
 *             .contentType("application/json")
 *             .content(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("foo", "bar"),
 *                     jsonProperty("fruit", jsonArray(
 *                         "apple",
 *                         "pear",
 *                         "orange"
 *                     )),
 *                     jsonProperty("isThingEnabled", true)
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ### Feature Flags
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appconfig.HostedConfigurationVersion;
 * import com.pulumi.aws.appconfig.HostedConfigurationVersionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HostedConfigurationVersion("example", HostedConfigurationVersionArgs.builder()
 *             .applicationId(aws_appconfig_application.example().id())
 *             .configurationProfileId(aws_appconfig_configuration_profile.example().configuration_profile_id())
 *             .description("Example Feature Flag Configuration Version")
 *             .contentType("application/json")
 *             .content(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("flags", jsonObject(
 *                         jsonProperty("foo", jsonObject(
 *                             jsonProperty("name", "foo"),
 *                             jsonProperty("_deprecation", jsonObject(
 *                                 jsonProperty("status", "planned")
 *                             ))
 *                         )),
 *                         jsonProperty("bar", jsonObject(
 *                             jsonProperty("name", "bar"),
 *                             jsonProperty("attributes", jsonObject(
 *                                 jsonProperty("someAttribute", jsonObject(
 *                                     jsonProperty("constraints", jsonObject(
 *                                         jsonProperty("type", "string"),
 *                                         jsonProperty("required", true)
 *                                     ))
 *                                 )),
 *                                 jsonProperty("someOtherAttribute", jsonObject(
 *                                     jsonProperty("constraints", jsonObject(
 *                                         jsonProperty("type", "number"),
 *                                         jsonProperty("required", true)
 *                                     ))
 *                                 ))
 *                             ))
 *                         ))
 *                     )),
 *                     jsonProperty("values", jsonObject(
 *                         jsonProperty("foo", jsonObject(
 *                             jsonProperty("enabled", "true")
 *                         )),
 *                         jsonProperty("bar", jsonObject(
 *                             jsonProperty("enabled", "true"),
 *                             jsonProperty("someAttribute", "Hello World"),
 *                             jsonProperty("someOtherAttribute", 123)
 *                         ))
 *                     )),
 *                     jsonProperty("version", "1")
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AppConfig Hosted Configuration Versions using the application ID, configuration profile ID, and version number separated by a slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:appconfig/hostedConfigurationVersion:HostedConfigurationVersion example 71abcde/11xxxxx/2
 * ```
 * @property applicationId Application ID.
 * @property configurationProfileId Configuration profile ID.
 * @property content Content of the configuration or the configuration data.
 * @property contentType Standard MIME type describing the format of the configuration content. For more information, see [Content-Type](https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17).
 * @property description Description of the configuration.
 */
public data class HostedConfigurationVersionArgs(
    public val applicationId: Output<String>? = null,
    public val configurationProfileId: Output<String>? = null,
    public val content: Output<String>? = null,
    public val contentType: Output<String>? = null,
    public val description: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appconfig.HostedConfigurationVersionArgs> {
    override fun toJava(): com.pulumi.aws.appconfig.HostedConfigurationVersionArgs =
        com.pulumi.aws.appconfig.HostedConfigurationVersionArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .configurationProfileId(configurationProfileId?.applyValue({ args0 -> args0 }))
            .content(content?.applyValue({ args0 -> args0 }))
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HostedConfigurationVersionArgs].
 */
@PulumiTagMarker
public class HostedConfigurationVersionArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var configurationProfileId: Output<String>? = null

    private var content: Output<String>? = null

    private var contentType: Output<String>? = null

    private var description: Output<String>? = null

    /**
     * @param value Application ID.
     */
    @JvmName("fhpytngahkjwbmvk")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value Configuration profile ID.
     */
    @JvmName("laqcrocllxroddxh")
    public suspend fun configurationProfileId(`value`: Output<String>) {
        this.configurationProfileId = value
    }

    /**
     * @param value Content of the configuration or the configuration data.
     */
    @JvmName("etuqbdsfalqefjnh")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value Standard MIME type describing the format of the configuration content. For more information, see [Content-Type](https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17).
     */
    @JvmName("mstteitovjsjqvwy")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value Description of the configuration.
     */
    @JvmName("dorfkkmpwtorfynk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Application ID.
     */
    @JvmName("gmxdvwkouytkcojh")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value Configuration profile ID.
     */
    @JvmName("dmvpiegydykjpgnv")
    public suspend fun configurationProfileId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationProfileId = mapped
    }

    /**
     * @param value Content of the configuration or the configuration data.
     */
    @JvmName("cfsgmqluhuuofpks")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value Standard MIME type describing the format of the configuration content. For more information, see [Content-Type](https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17).
     */
    @JvmName("ukgqemnojogcpsof")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Description of the configuration.
     */
    @JvmName("ugmakvwifetdmfox")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    internal fun build(): HostedConfigurationVersionArgs = HostedConfigurationVersionArgs(
        applicationId = applicationId,
        configurationProfileId = configurationProfileId,
        content = content,
        contentType = contentType,
        description = description,
    )
}
