@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin.inputs

import com.pulumi.aws.appconfig.inputs.ConfigurationProfileValidatorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property content Either the JSON Schema content or the ARN of an AWS Lambda function.
 * @property type Type of validator. Valid values: `JSON_SCHEMA` and `LAMBDA`.
 */
public data class ConfigurationProfileValidatorArgs(
    public val content: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appconfig.inputs.ConfigurationProfileValidatorArgs> {
    override fun toJava(): com.pulumi.aws.appconfig.inputs.ConfigurationProfileValidatorArgs =
        com.pulumi.aws.appconfig.inputs.ConfigurationProfileValidatorArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationProfileValidatorArgs].
 */
@PulumiTagMarker
public class ConfigurationProfileValidatorArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Either the JSON Schema content or the ARN of an AWS Lambda function.
     */
    @JvmName("wstjqjvlqyitarsr")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value Type of validator. Valid values: `JSON_SCHEMA` and `LAMBDA`.
     */
    @JvmName("atgkhqygpgciltya")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Either the JSON Schema content or the ARN of an AWS Lambda function.
     */
    @JvmName("eoxnlgullpqqpjqx")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value Type of validator. Valid values: `JSON_SCHEMA` and `LAMBDA`.
     */
    @JvmName("ycjxqepwfgqpoice")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ConfigurationProfileValidatorArgs = ConfigurationProfileValidatorArgs(
        content = content,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
