@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin.inputs

import com.pulumi.aws.appconfig.inputs.EventIntegrationEventFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property source Source of the events.
 */
public data class EventIntegrationEventFilterArgs(
    public val source: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appconfig.inputs.EventIntegrationEventFilterArgs> {
    override fun toJava(): com.pulumi.aws.appconfig.inputs.EventIntegrationEventFilterArgs =
        com.pulumi.aws.appconfig.inputs.EventIntegrationEventFilterArgs.builder()
            .source(source.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventIntegrationEventFilterArgs].
 */
@PulumiTagMarker
public class EventIntegrationEventFilterArgsBuilder internal constructor() {
    private var source: Output<String>? = null

    /**
     * @param value Source of the events.
     */
    @JvmName("imcuubrohrlwuics")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value Source of the events.
     */
    @JvmName("cikkevfoskoqmeic")
    public suspend fun source(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    internal fun build(): EventIntegrationEventFilterArgs = EventIntegrationEventFilterArgs(
        source = source ?: throw PulumiNullFieldException("source"),
    )
}
