@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin.inputs

import com.pulumi.aws.appconfig.inputs.ExtensionActionPointActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description Information about the action.
 * @property name The action name.
 * @property roleArn An Amazon Resource Name (ARN) for an Identity and Access Management assume role.
 * @property uri The extension URI associated to the action point in the extension definition. The URI can be an Amazon Resource Name (ARN) for one of the following: an Lambda function, an Amazon Simple Queue Service queue, an Amazon Simple Notification Service topic, or the Amazon EventBridge default event bus.
 */
public data class ExtensionActionPointActionArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>,
    public val roleArn: Output<String>,
    public val uri: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appconfig.inputs.ExtensionActionPointActionArgs> {
    override fun toJava(): com.pulumi.aws.appconfig.inputs.ExtensionActionPointActionArgs =
        com.pulumi.aws.appconfig.inputs.ExtensionActionPointActionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .uri(uri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExtensionActionPointActionArgs].
 */
@PulumiTagMarker
public class ExtensionActionPointActionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var uri: Output<String>? = null

    /**
     * @param value Information about the action.
     */
    @JvmName("coaeprgwrdummsnn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The action name.
     */
    @JvmName("baphrwiegacukqve")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value An Amazon Resource Name (ARN) for an Identity and Access Management assume role.
     */
    @JvmName("mvehxeyduipkywcr")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The extension URI associated to the action point in the extension definition. The URI can be an Amazon Resource Name (ARN) for one of the following: an Lambda function, an Amazon Simple Queue Service queue, an Amazon Simple Notification Service topic, or the Amazon EventBridge default event bus.
     */
    @JvmName("qcecpxfaxjqbvywn")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value Information about the action.
     */
    @JvmName("wsuohqfwyemqwkis")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The action name.
     */
    @JvmName("vfqjjyvhjjxwtjca")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value An Amazon Resource Name (ARN) for an Identity and Access Management assume role.
     */
    @JvmName("nxhcckayxphoxwcw")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The extension URI associated to the action point in the extension definition. The URI can be an Amazon Resource Name (ARN) for one of the following: an Lambda function, an Amazon Simple Queue Service queue, an Amazon Simple Notification Service topic, or the Amazon EventBridge default event bus.
     */
    @JvmName("nvmdqaaktfkfbfax")
    public suspend fun uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): ExtensionActionPointActionArgs = ExtensionActionPointActionArgs(
        description = description,
        name = name ?: throw PulumiNullFieldException("name"),
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        uri = uri ?: throw PulumiNullFieldException("uri"),
    )
}
