@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin.inputs

import com.pulumi.aws.appconfig.inputs.ExtensionActionPointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property actions An action defines the tasks the extension performs during the AppConfig workflow. Detailed below.
 * @property point The point at which to perform the defined actions. Valid points are `PRE_CREATE_HOSTED_CONFIGURATION_VERSION`, `PRE_START_DEPLOYMENT`, `ON_DEPLOYMENT_START`, `ON_DEPLOYMENT_STEP`, `ON_DEPLOYMENT_BAKING`, `ON_DEPLOYMENT_COMPLETE`, `ON_DEPLOYMENT_ROLLED_BACK`.
 */
public data class ExtensionActionPointArgs(
    public val actions: Output<List<ExtensionActionPointActionArgs>>,
    public val point: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appconfig.inputs.ExtensionActionPointArgs> {
    override fun toJava(): com.pulumi.aws.appconfig.inputs.ExtensionActionPointArgs =
        com.pulumi.aws.appconfig.inputs.ExtensionActionPointArgs.builder()
            .actions(
                actions.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .point(point.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExtensionActionPointArgs].
 */
@PulumiTagMarker
public class ExtensionActionPointArgsBuilder internal constructor() {
    private var actions: Output<List<ExtensionActionPointActionArgs>>? = null

    private var point: Output<String>? = null

    /**
     * @param value An action defines the tasks the extension performs during the AppConfig workflow. Detailed below.
     */
    @JvmName("bjuojgwcwfjpvqjo")
    public suspend fun actions(`value`: Output<List<ExtensionActionPointActionArgs>>) {
        this.actions = value
    }

    @JvmName("hjtnythgbnvsnrmc")
    public suspend fun actions(vararg values: Output<ExtensionActionPointActionArgs>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values An action defines the tasks the extension performs during the AppConfig workflow. Detailed below.
     */
    @JvmName("qgmfcxmsygkcnaro")
    public suspend fun actions(values: List<Output<ExtensionActionPointActionArgs>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value The point at which to perform the defined actions. Valid points are `PRE_CREATE_HOSTED_CONFIGURATION_VERSION`, `PRE_START_DEPLOYMENT`, `ON_DEPLOYMENT_START`, `ON_DEPLOYMENT_STEP`, `ON_DEPLOYMENT_BAKING`, `ON_DEPLOYMENT_COMPLETE`, `ON_DEPLOYMENT_ROLLED_BACK`.
     */
    @JvmName("pkbfuqebmolyxkla")
    public suspend fun point(`value`: Output<String>) {
        this.point = value
    }

    /**
     * @param value An action defines the tasks the extension performs during the AppConfig workflow. Detailed below.
     */
    @JvmName("wevsuqvafbvfwdjt")
    public suspend fun actions(`value`: List<ExtensionActionPointActionArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param argument An action defines the tasks the extension performs during the AppConfig workflow. Detailed below.
     */
    @JvmName("mqxkiryfwkeacxyk")
    public suspend
    fun actions(argument: List<suspend ExtensionActionPointActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExtensionActionPointActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument An action defines the tasks the extension performs during the AppConfig workflow. Detailed below.
     */
    @JvmName("usnvfxvtcfnvmkgt")
    public suspend fun actions(
        vararg
        argument: suspend ExtensionActionPointActionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ExtensionActionPointActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument An action defines the tasks the extension performs during the AppConfig workflow. Detailed below.
     */
    @JvmName("kwypfqsskkgfjptg")
    public suspend fun actions(argument: suspend ExtensionActionPointActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ExtensionActionPointActionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param values An action defines the tasks the extension performs during the AppConfig workflow. Detailed below.
     */
    @JvmName("ixyeojdwmjlbcfje")
    public suspend fun actions(vararg values: ExtensionActionPointActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value The point at which to perform the defined actions. Valid points are `PRE_CREATE_HOSTED_CONFIGURATION_VERSION`, `PRE_START_DEPLOYMENT`, `ON_DEPLOYMENT_START`, `ON_DEPLOYMENT_STEP`, `ON_DEPLOYMENT_BAKING`, `ON_DEPLOYMENT_COMPLETE`, `ON_DEPLOYMENT_ROLLED_BACK`.
     */
    @JvmName("bjwyipttqcehwfpw")
    public suspend fun point(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.point = mapped
    }

    internal fun build(): ExtensionActionPointArgs = ExtensionActionPointArgs(
        actions = actions ?: throw PulumiNullFieldException("actions"),
        point = point ?: throw PulumiNullFieldException("point"),
    )
}
