@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin.inputs

import com.pulumi.aws.appconfig.inputs.ExtensionParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description Information about the parameter.
 * @property name The parameter name.
 * @property required Determines if a parameter value must be specified in the extension association.
 */
public data class ExtensionParameterArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>,
    public val required: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.appconfig.inputs.ExtensionParameterArgs> {
    override fun toJava(): com.pulumi.aws.appconfig.inputs.ExtensionParameterArgs =
        com.pulumi.aws.appconfig.inputs.ExtensionParameterArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .required(required?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExtensionParameterArgs].
 */
@PulumiTagMarker
public class ExtensionParameterArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var required: Output<Boolean>? = null

    /**
     * @param value Information about the parameter.
     */
    @JvmName("pjlbmrkkdaxyalsi")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The parameter name.
     */
    @JvmName("qhjgolmqbtehwpix")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Determines if a parameter value must be specified in the extension association.
     */
    @JvmName("ykslvvjrdibxbebq")
    public suspend fun required(`value`: Output<Boolean>) {
        this.required = value
    }

    /**
     * @param value Information about the parameter.
     */
    @JvmName("owbpusgyovuuvatx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The parameter name.
     */
    @JvmName("fmlcgxtlbwjnbqem")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Determines if a parameter value must be specified in the extension association.
     */
    @JvmName("awbpsairmgvfwppw")
    public suspend fun required(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.required = mapped
    }

    internal fun build(): ExtensionParameterArgs = ExtensionParameterArgs(
        description = description,
        name = name ?: throw PulumiNullFieldException("name"),
        required = required,
    )
}
