@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin.inputs

import com.pulumi.aws.appconfig.inputs.GetConfigurationProfilesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getConfigurationProfiles.
 * @property applicationId ID of the AppConfig Application.
 */
public data class GetConfigurationProfilesPlainArgs(
    public val applicationId: String,
) : ConvertibleToJava<com.pulumi.aws.appconfig.inputs.GetConfigurationProfilesPlainArgs> {
    override fun toJava(): com.pulumi.aws.appconfig.inputs.GetConfigurationProfilesPlainArgs =
        com.pulumi.aws.appconfig.inputs.GetConfigurationProfilesPlainArgs.builder()
            .applicationId(applicationId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConfigurationProfilesPlainArgs].
 */
@PulumiTagMarker
public class GetConfigurationProfilesPlainArgsBuilder internal constructor() {
    private var applicationId: String? = null

    /**
     * @param value ID of the AppConfig Application.
     */
    @JvmName("npldqluufgifsgat")
    public suspend fun applicationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationId = mapped
    }

    internal fun build(): GetConfigurationProfilesPlainArgs = GetConfigurationProfilesPlainArgs(
        applicationId = applicationId ?: throw PulumiNullFieldException("applicationId"),
    )
}
