@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin.inputs

import com.pulumi.aws.appconfig.inputs.GetEnvironmentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEnvironments.
 * @property applicationId ID of the AppConfig Application.
 */
public data class GetEnvironmentsPlainArgs(
    public val applicationId: String,
) : ConvertibleToJava<com.pulumi.aws.appconfig.inputs.GetEnvironmentsPlainArgs> {
    override fun toJava(): com.pulumi.aws.appconfig.inputs.GetEnvironmentsPlainArgs =
        com.pulumi.aws.appconfig.inputs.GetEnvironmentsPlainArgs.builder()
            .applicationId(applicationId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEnvironmentsPlainArgs].
 */
@PulumiTagMarker
public class GetEnvironmentsPlainArgsBuilder internal constructor() {
    private var applicationId: String? = null

    /**
     * @param value ID of the AppConfig Application.
     */
    @JvmName("smoeebsmqkkeguff")
    public suspend fun applicationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationId = mapped
    }

    internal fun build(): GetEnvironmentsPlainArgs = GetEnvironmentsPlainArgs(
        applicationId = applicationId ?: throw PulumiNullFieldException("applicationId"),
    )
}
