@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property content Either the JSON Schema content or the ARN of an AWS Lambda function.
 * @property type Type of validator. Valid values: `JSON_SCHEMA` and `LAMBDA`.
 */
public data class ConfigurationProfileValidator(
    public val content: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appconfig.outputs.ConfigurationProfileValidator):
            ConfigurationProfileValidator = ConfigurationProfileValidator(
            content = javaType.content().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
