@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property alarmArn ARN of the Amazon CloudWatch alarm.
 * @property alarmRoleArn ARN of an IAM role for AWS AppConfig to monitor `alarm_arn`.
 */
public data class EnvironmentMonitor(
    public val alarmArn: String,
    public val alarmRoleArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appconfig.outputs.EnvironmentMonitor):
            EnvironmentMonitor = EnvironmentMonitor(
            alarmArn = javaType.alarmArn(),
            alarmRoleArn = javaType.alarmRoleArn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
