@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description Information about the action.
 * @property name The action name.
 * @property roleArn An Amazon Resource Name (ARN) for an Identity and Access Management assume role.
 * @property uri The extension URI associated to the action point in the extension definition. The URI can be an Amazon Resource Name (ARN) for one of the following: an Lambda function, an Amazon Simple Queue Service queue, an Amazon Simple Notification Service topic, or the Amazon EventBridge default event bus.
 */
public data class ExtensionActionPointAction(
    public val description: String? = null,
    public val name: String,
    public val roleArn: String,
    public val uri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appconfig.outputs.ExtensionActionPointAction):
            ExtensionActionPointAction = ExtensionActionPointAction(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            roleArn = javaType.roleArn(),
            uri = javaType.uri(),
        )
    }
}
