@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getConfigurationProfile.
 * @property applicationId
 * @property arn ARN of the Configuration Profile.
 * @property configurationProfileId
 * @property description Description of the Configuration Profile.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property locationUri Location URI of the Configuration Profile.
 * @property name Name of the Configuration Profile.
 * @property retrievalRoleArn ARN of an IAM role with permission to access the configuration at the specified location_uri.
 * @property tags Map of tags for the resource.
 * @property type Type of validator. Valid values: JSON_SCHEMA and LAMBDA.
 * @property validators Nested list of methods for validating the configuration.
 */
public data class GetConfigurationProfileResult(
    public val applicationId: String,
    public val arn: String,
    public val configurationProfileId: String,
    public val description: String,
    public val id: String,
    public val locationUri: String,
    public val name: String,
    public val retrievalRoleArn: String,
    public val tags: Map<String, String>,
    public val type: String,
    public val validators: List<GetConfigurationProfileValidator>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appconfig.outputs.GetConfigurationProfileResult):
            GetConfigurationProfileResult = GetConfigurationProfileResult(
            applicationId = javaType.applicationId(),
            arn = javaType.arn(),
            configurationProfileId = javaType.configurationProfileId(),
            description = javaType.description(),
            id = javaType.id(),
            locationUri = javaType.locationUri(),
            name = javaType.name(),
            retrievalRoleArn = javaType.retrievalRoleArn(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            validators = javaType.validators().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appconfig.kotlin.outputs.GetConfigurationProfileValidator.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
