@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property content Either the JSON Schema content or the ARN of an AWS Lambda function.
 * @property type Type of validator. Valid values: JSON_SCHEMA and LAMBDA.
 */
public data class GetConfigurationProfileValidator(
    public val content: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appconfig.outputs.GetConfigurationProfileValidator):
            GetConfigurationProfileValidator = GetConfigurationProfileValidator(
            content = javaType.content(),
            type = javaType.type(),
        )
    }
}
