@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getConfigurationProfiles.
 * @property applicationId
 * @property configurationProfileIds Set of Configuration Profile IDs associated with the AppConfig Application.
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetConfigurationProfilesResult(
    public val applicationId: String,
    public val configurationProfileIds: List<String>,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appconfig.outputs.GetConfigurationProfilesResult):
            GetConfigurationProfilesResult = GetConfigurationProfilesResult(
            applicationId = javaType.applicationId(),
            configurationProfileIds = javaType.configurationProfileIds().map({ args0 -> args0 }),
            id = javaType.id(),
        )
    }
}
