@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property alarmArn ARN of the Amazon CloudWatch alarm.
 * @property alarmRoleArn ARN of an IAM role for AWS AppConfig to monitor.
 */
public data class GetEnvironmentMonitor(
    public val alarmArn: String,
    public val alarmRoleArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appconfig.outputs.GetEnvironmentMonitor):
            GetEnvironmentMonitor = GetEnvironmentMonitor(
            alarmArn = javaType.alarmArn(),
            alarmRoleArn = javaType.alarmRoleArn(),
        )
    }
}
