@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin

import com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfig
import com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ConnectorProfile].
 */
@PulumiTagMarker
public class ConnectorProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectorProfileArgs = ConnectorProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectorProfileArgsBuilder.() -> Unit) {
        val builder = ConnectorProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConnectorProfile {
        val builtJavaResource = com.pulumi.aws.appflow.ConnectorProfile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ConnectorProfile(builtJavaResource)
    }
}

/**
 * Provides an AppFlow connector profile resource.
 * For information about AppFlow flows, see the [Amazon AppFlow API Reference](https://docs.aws.amazon.com/appflow/1.0/APIReference/Welcome.html).
 * For specific information about creating an AppFlow connector profile, see the
 * [CreateConnectorProfile](https://docs.aws.amazon.com/appflow/1.0/APIReference/API_CreateConnectorProfile.html) page in the Amazon AppFlow API Reference.
 * ## Import
 * Using `pulumi import`, import AppFlow Connector Profile using the connector profile `arn`. For example:
 * ```sh
 *  $ pulumi import aws:appflow/connectorProfile:ConnectorProfile profile arn:aws:appflow:us-west-2:123456789012:connectorprofile/example-profile
 * ```
 *
 */
public class ConnectorProfile internal constructor(
    override val javaResource: com.pulumi.aws.appflow.ConnectorProfile,
) : KotlinCustomResource(javaResource, ConnectorProfileMapper) {
    /**
     * ARN of the connector profile.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Indicates the connection mode and specifies whether it is public or private. Private flows use AWS PrivateLink to route data over AWS infrastructure without exposing it to the public internet. One of: `Public`, `Private`.
     */
    public val connectionMode: Output<String>
        get() = javaResource.connectionMode().applyValue({ args0 -> args0 })

    /**
     * The label of the connector. The label is unique for each ConnectorRegistration in your AWS account. Only needed if calling for `CustomConnector` connector type.
     */
    public val connectorLabel: Output<String>?
        get() = javaResource.connectorLabel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Defines the connector-specific configuration and credentials. See Connector Profile Config for more details.
     */
    public val connectorProfileConfig: Output<ConnectorProfileConnectorProfileConfig>
        get() = javaResource.connectorProfileConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The type of connector. One of: `Amplitude`, `CustomConnector`, `CustomerProfiles`, `Datadog`, `Dynatrace`, `EventBridge`, `Googleanalytics`, `Honeycode`, `Infornexus`, `LookoutMetrics`, `Marketo`, `Redshift`, `S3`, `Salesforce`, `SAPOData`, `Servicenow`, `Singular`, `Slack`, `Snowflake`, `Trendmicro`, `Upsolver`, `Veeva`, `Zendesk`.
     */
    public val connectorType: Output<String>
        get() = javaResource.connectorType().applyValue({ args0 -> args0 })

    /**
     * ARN of the connector profile credentials.
     */
    public val credentialsArn: Output<String>
        get() = javaResource.credentialsArn().applyValue({ args0 -> args0 })

    /**
     * ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
     */
    public val kmsArn: Output<String>
        get() = javaResource.kmsArn().applyValue({ args0 -> args0 })

    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object ConnectorProfileMapper : ResourceMapper<ConnectorProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appflow.ConnectorProfile::class == javaResource::class

    override fun map(javaResource: Resource): ConnectorProfile = ConnectorProfile(
        javaResource as
            com.pulumi.aws.appflow.ConnectorProfile,
    )
}

/**
 * @see [ConnectorProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectorProfile].
 */
public suspend fun connectorProfile(
    name: String,
    block: suspend ConnectorProfileResourceBuilder.() -> Unit,
): ConnectorProfile {
    val builder = ConnectorProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectorProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectorProfile(name: String): ConnectorProfile {
    val builder = ConnectorProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
