@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin

import com.pulumi.aws.appflow.ConnectorProfileArgs.builder
import com.pulumi.aws.appflow.kotlin.inputs.ConnectorProfileConnectorProfileConfigArgs
import com.pulumi.aws.appflow.kotlin.inputs.ConnectorProfileConnectorProfileConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an AppFlow connector profile resource.
 * For information about AppFlow flows, see the [Amazon AppFlow API Reference](https://docs.aws.amazon.com/appflow/1.0/APIReference/Welcome.html).
 * For specific information about creating an AppFlow connector profile, see the
 * [CreateConnectorProfile](https://docs.aws.amazon.com/appflow/1.0/APIReference/API_CreateConnectorProfile.html) page in the Amazon AppFlow API Reference.
 * ## Import
 * Using `pulumi import`, import AppFlow Connector Profile using the connector profile `arn`. For example:
 * ```sh
 *  $ pulumi import aws:appflow/connectorProfile:ConnectorProfile profile arn:aws:appflow:us-west-2:123456789012:connectorprofile/example-profile
 * ```
 * @property connectionMode Indicates the connection mode and specifies whether it is public or private. Private flows use AWS PrivateLink to route data over AWS infrastructure without exposing it to the public internet. One of: `Public`, `Private`.
 * @property connectorLabel The label of the connector. The label is unique for each ConnectorRegistration in your AWS account. Only needed if calling for `CustomConnector` connector type.
 * @property connectorProfileConfig Defines the connector-specific configuration and credentials. See Connector Profile Config for more details.
 * @property connectorType The type of connector. One of: `Amplitude`, `CustomConnector`, `CustomerProfiles`, `Datadog`, `Dynatrace`, `EventBridge`, `Googleanalytics`, `Honeycode`, `Infornexus`, `LookoutMetrics`, `Marketo`, `Redshift`, `S3`, `Salesforce`, `SAPOData`, `Servicenow`, `Singular`, `Slack`, `Snowflake`, `Trendmicro`, `Upsolver`, `Veeva`, `Zendesk`.
 * @property kmsArn ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
 * @property name
 */
public data class ConnectorProfileArgs(
    public val connectionMode: Output<String>? = null,
    public val connectorLabel: Output<String>? = null,
    public val connectorProfileConfig: Output<ConnectorProfileConnectorProfileConfigArgs>? = null,
    public val connectorType: Output<String>? = null,
    public val kmsArn: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appflow.ConnectorProfileArgs> {
    override fun toJava(): com.pulumi.aws.appflow.ConnectorProfileArgs =
        com.pulumi.aws.appflow.ConnectorProfileArgs.builder()
            .connectionMode(connectionMode?.applyValue({ args0 -> args0 }))
            .connectorLabel(connectorLabel?.applyValue({ args0 -> args0 }))
            .connectorProfileConfig(
                connectorProfileConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .connectorType(connectorType?.applyValue({ args0 -> args0 }))
            .kmsArn(kmsArn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileArgs].
 */
@PulumiTagMarker
public class ConnectorProfileArgsBuilder internal constructor() {
    private var connectionMode: Output<String>? = null

    private var connectorLabel: Output<String>? = null

    private var connectorProfileConfig: Output<ConnectorProfileConnectorProfileConfigArgs>? = null

    private var connectorType: Output<String>? = null

    private var kmsArn: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Indicates the connection mode and specifies whether it is public or private. Private flows use AWS PrivateLink to route data over AWS infrastructure without exposing it to the public internet. One of: `Public`, `Private`.
     */
    @JvmName("nesoqaygaayxhhog")
    public suspend fun connectionMode(`value`: Output<String>) {
        this.connectionMode = value
    }

    /**
     * @param value The label of the connector. The label is unique for each ConnectorRegistration in your AWS account. Only needed if calling for `CustomConnector` connector type.
     */
    @JvmName("xltmslqetlwnfjsg")
    public suspend fun connectorLabel(`value`: Output<String>) {
        this.connectorLabel = value
    }

    /**
     * @param value Defines the connector-specific configuration and credentials. See Connector Profile Config for more details.
     */
    @JvmName("qmfraeqorbiqtrbv")
    public suspend
    fun connectorProfileConfig(`value`: Output<ConnectorProfileConnectorProfileConfigArgs>) {
        this.connectorProfileConfig = value
    }

    /**
     * @param value The type of connector. One of: `Amplitude`, `CustomConnector`, `CustomerProfiles`, `Datadog`, `Dynatrace`, `EventBridge`, `Googleanalytics`, `Honeycode`, `Infornexus`, `LookoutMetrics`, `Marketo`, `Redshift`, `S3`, `Salesforce`, `SAPOData`, `Servicenow`, `Singular`, `Slack`, `Snowflake`, `Trendmicro`, `Upsolver`, `Veeva`, `Zendesk`.
     */
    @JvmName("vkdbmikhdawiwanu")
    public suspend fun connectorType(`value`: Output<String>) {
        this.connectorType = value
    }

    /**
     * @param value ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
     */
    @JvmName("ykprrsmwlqrkcefd")
    public suspend fun kmsArn(`value`: Output<String>) {
        this.kmsArn = value
    }

    /**
     * @param value
     */
    @JvmName("oofbbrlxnhhuvflk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Indicates the connection mode and specifies whether it is public or private. Private flows use AWS PrivateLink to route data over AWS infrastructure without exposing it to the public internet. One of: `Public`, `Private`.
     */
    @JvmName("hqnfneqaeydicmyq")
    public suspend fun connectionMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionMode = mapped
    }

    /**
     * @param value The label of the connector. The label is unique for each ConnectorRegistration in your AWS account. Only needed if calling for `CustomConnector` connector type.
     */
    @JvmName("mpmcgkcscwswhibg")
    public suspend fun connectorLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectorLabel = mapped
    }

    /**
     * @param value Defines the connector-specific configuration and credentials. See Connector Profile Config for more details.
     */
    @JvmName("wqwfvkuhccswxsyt")
    public suspend fun connectorProfileConfig(`value`: ConnectorProfileConnectorProfileConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectorProfileConfig = mapped
    }

    /**
     * @param argument Defines the connector-specific configuration and credentials. See Connector Profile Config for more details.
     */
    @JvmName("dssuqjfuhuvwprre")
    public suspend
    fun connectorProfileConfig(argument: suspend ConnectorProfileConnectorProfileConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorProfileConnectorProfileConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.connectorProfileConfig = mapped
    }

    /**
     * @param value The type of connector. One of: `Amplitude`, `CustomConnector`, `CustomerProfiles`, `Datadog`, `Dynatrace`, `EventBridge`, `Googleanalytics`, `Honeycode`, `Infornexus`, `LookoutMetrics`, `Marketo`, `Redshift`, `S3`, `Salesforce`, `SAPOData`, `Servicenow`, `Singular`, `Slack`, `Snowflake`, `Trendmicro`, `Upsolver`, `Veeva`, `Zendesk`.
     */
    @JvmName("hopyhtgngpwhwqge")
    public suspend fun connectorType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectorType = mapped
    }

    /**
     * @param value ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
     */
    @JvmName("erfoxrhjapotaxfy")
    public suspend fun kmsArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsArn = mapped
    }

    /**
     * @param value
     */
    @JvmName("dkcofgsqpbcgcaqp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ConnectorProfileArgs = ConnectorProfileArgs(
        connectionMode = connectionMode,
        connectorLabel = connectorLabel,
        connectorProfileConfig = connectorProfileConfig,
        connectorType = connectorType,
        kmsArn = kmsArn,
        name = name,
    )
}
