@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin

import com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfig
import com.pulumi.aws.appflow.kotlin.outputs.FlowSourceFlowConfig
import com.pulumi.aws.appflow.kotlin.outputs.FlowTask
import com.pulumi.aws.appflow.kotlin.outputs.FlowTriggerConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfig.Companion.toKotlin as flowDestinationFlowConfigToKotlin
import com.pulumi.aws.appflow.kotlin.outputs.FlowSourceFlowConfig.Companion.toKotlin as flowSourceFlowConfigToKotlin
import com.pulumi.aws.appflow.kotlin.outputs.FlowTask.Companion.toKotlin as flowTaskToKotlin
import com.pulumi.aws.appflow.kotlin.outputs.FlowTriggerConfig.Companion.toKotlin as flowTriggerConfigToKotlin

/**
 * Builder for [Flow].
 */
@PulumiTagMarker
public class FlowResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FlowArgs = FlowArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FlowArgsBuilder.() -> Unit) {
        val builder = FlowArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Flow {
        val builtJavaResource = com.pulumi.aws.appflow.Flow(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Flow(builtJavaResource)
    }
}

/**
 * Provides an AppFlow flow resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.s3.BucketPolicy;
 * import com.pulumi.aws.s3.BucketPolicyArgs;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.appflow.Flow;
 * import com.pulumi.aws.appflow.FlowArgs;
 * import com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigArgs;
 * import com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesArgs;
 * import com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesS3Args;
 * import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigArgs;
 * import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesArgs;
 * import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3Args;
 * import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigArgs;
 * import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigPrefixConfigArgs;
 * import com.pulumi.aws.appflow.inputs.FlowTaskArgs;
 * import com.pulumi.aws.appflow.inputs.FlowTriggerConfigArgs;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleSourceBucketV2 = new BucketV2("exampleSourceBucketV2");
 *         final var exampleSourcePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("AllowAppFlowSourceActions")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("appflow.amazonaws.com")
 *                     .build())
 *                 .actions(
 *                     "s3:ListBucket",
 *                     "s3:GetObject")
 *                 .resources(
 *                     "arn:aws:s3:::example-source",
 *                     "arn:aws:s3:::example-source/*")
 *                 .build())
 *             .build());
 *         var exampleSourceBucketPolicy = new BucketPolicy("exampleSourceBucketPolicy", BucketPolicyArgs.builder()
 *             .bucket(exampleSourceBucketV2.id())
 *             .policy(exampleSourcePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleBucketObjectv2 = new BucketObjectv2("exampleBucketObjectv2", BucketObjectv2Args.builder()
 *             .bucket(exampleSourceBucketV2.id())
 *             .key("example_source.csv")
 *             .source(new FileAsset("example_source.csv"))
 *             .build());
 *         var exampleDestinationBucketV2 = new BucketV2("exampleDestinationBucketV2");
 *         final var exampleDestinationPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("AllowAppFlowDestinationActions")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("appflow.amazonaws.com")
 *                     .build())
 *                 .actions(
 *                     "s3:PutObject",
 *                     "s3:AbortMultipartUpload",
 *                     "s3:ListMultipartUploadParts",
 *                     "s3:ListBucketMultipartUploads",
 *                     "s3:GetBucketAcl",
 *                     "s3:PutObjectAcl")
 *                 .resources(
 *                     "arn:aws:s3:::example-destination",
 *                     "arn:aws:s3:::example-destination/*")
 *                 .build())
 *             .build());
 *         var exampleDestinationBucketPolicy = new BucketPolicy("exampleDestinationBucketPolicy", BucketPolicyArgs.builder()
 *             .bucket(exampleDestinationBucketV2.id())
 *             .policy(exampleDestinationPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleFlow = new Flow("exampleFlow", FlowArgs.builder()
 *             .sourceFlowConfig(FlowSourceFlowConfigArgs.builder()
 *                 .connectorType("S3")
 *                 .sourceConnectorProperties(FlowSourceFlowConfigSourceConnectorPropertiesArgs.builder()
 *                     .s3(FlowSourceFlowConfigSourceConnectorPropertiesS3Args.builder()
 *                         .bucketName(exampleSourceBucketPolicy.bucket())
 *                         .bucketPrefix("example")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .destinationFlowConfigs(FlowDestinationFlowConfigArgs.builder()
 *                 .connectorType("S3")
 *                 .destinationConnectorProperties(FlowDestinationFlowConfigDestinationConnectorPropertiesArgs.builder()
 *                     .s3(FlowDestinationFlowConfigDestinationConnectorPropertiesS3Args.builder()
 *                         .bucketName(exampleDestinationBucketPolicy.bucket())
 *                         .s3OutputFormatConfig(FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigArgs.builder()
 *                             .prefixConfig(FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigPrefixConfigArgs.builder()
 *                                 .prefixType("PATH")
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .tasks(FlowTaskArgs.builder()
 *                 .sourceFields("exampleField")
 *                 .destinationField("exampleField")
 *                 .taskType("Map")
 *                 .connectorOperators(FlowTaskConnectorOperatorArgs.builder()
 *                     .s3("NO_OP")
 *                     .build())
 *                 .build())
 *             .triggerConfig(FlowTriggerConfigArgs.builder()
 *                 .triggerType("OnDemand")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AppFlow flows using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:appflow/flow:Flow example arn:aws:appflow:us-west-2:123456789012:flow/example-flow
 * ```
 * */*/
 */
public class Flow internal constructor(
    override val javaResource: com.pulumi.aws.appflow.Flow,
) : KotlinCustomResource(javaResource, FlowMapper) {
    /**
     * Flow's ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of the flow you want to create.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A Destination Flow Config that controls how Amazon AppFlow places data in the destination connector.
     */
    public val destinationFlowConfigs: Output<List<FlowDestinationFlowConfig>>
        get() = javaResource.destinationFlowConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> flowDestinationFlowConfigToKotlin(args0) })
            })
        })

    /**
     * ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
     */
    public val kmsArn: Output<String>
        get() = javaResource.kmsArn().applyValue({ args0 -> args0 })

    /**
     * Name of the flow.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Source Flow Config that controls how Amazon AppFlow retrieves data from the source connector.
     */
    public val sourceFlowConfig: Output<FlowSourceFlowConfig>
        get() = javaResource.sourceFlowConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                flowSourceFlowConfigToKotlin(args0)
            })
        })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A Task that Amazon AppFlow performs while transferring the data in the flow run.
     */
    public val tasks: Output<List<FlowTask>>
        get() = javaResource.tasks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    flowTaskToKotlin(args0)
                })
            })
        })

    /**
     * A Trigger that determine how and when the flow runs.
     */
    public val triggerConfig: Output<FlowTriggerConfig>
        get() = javaResource.triggerConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                flowTriggerConfigToKotlin(args0)
            })
        })
}

public object FlowMapper : ResourceMapper<Flow> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appflow.Flow::class == javaResource::class

    override fun map(javaResource: Resource): Flow = Flow(javaResource as com.pulumi.aws.appflow.Flow)
}

/**
 * @see [Flow].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Flow].
 */
public suspend fun flow(name: String, block: suspend FlowResourceBuilder.() -> Unit): Flow {
    val builder = FlowResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Flow].
 * @param name The _unique_ name of the resulting resource.
 */
public fun flow(name: String): Flow {
    val builder = FlowResourceBuilder()
    builder.name(name)
    return builder.build()
}
