@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin

import com.pulumi.aws.appflow.FlowArgs.builder
import com.pulumi.aws.appflow.kotlin.inputs.FlowDestinationFlowConfigArgs
import com.pulumi.aws.appflow.kotlin.inputs.FlowDestinationFlowConfigArgsBuilder
import com.pulumi.aws.appflow.kotlin.inputs.FlowSourceFlowConfigArgs
import com.pulumi.aws.appflow.kotlin.inputs.FlowSourceFlowConfigArgsBuilder
import com.pulumi.aws.appflow.kotlin.inputs.FlowTaskArgs
import com.pulumi.aws.appflow.kotlin.inputs.FlowTaskArgsBuilder
import com.pulumi.aws.appflow.kotlin.inputs.FlowTriggerConfigArgs
import com.pulumi.aws.appflow.kotlin.inputs.FlowTriggerConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AppFlow flow resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.s3.BucketPolicy;
 * import com.pulumi.aws.s3.BucketPolicyArgs;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.appflow.Flow;
 * import com.pulumi.aws.appflow.FlowArgs;
 * import com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigArgs;
 * import com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesArgs;
 * import com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesS3Args;
 * import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigArgs;
 * import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesArgs;
 * import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3Args;
 * import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigArgs;
 * import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigPrefixConfigArgs;
 * import com.pulumi.aws.appflow.inputs.FlowTaskArgs;
 * import com.pulumi.aws.appflow.inputs.FlowTriggerConfigArgs;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleSourceBucketV2 = new BucketV2("exampleSourceBucketV2");
 *         final var exampleSourcePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("AllowAppFlowSourceActions")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("appflow.amazonaws.com")
 *                     .build())
 *                 .actions(
 *                     "s3:ListBucket",
 *                     "s3:GetObject")
 *                 .resources(
 *                     "arn:aws:s3:::example-source",
 *                     "arn:aws:s3:::example-source/*")
 *                 .build())
 *             .build());
 *         var exampleSourceBucketPolicy = new BucketPolicy("exampleSourceBucketPolicy", BucketPolicyArgs.builder()
 *             .bucket(exampleSourceBucketV2.id())
 *             .policy(exampleSourcePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleBucketObjectv2 = new BucketObjectv2("exampleBucketObjectv2", BucketObjectv2Args.builder()
 *             .bucket(exampleSourceBucketV2.id())
 *             .key("example_source.csv")
 *             .source(new FileAsset("example_source.csv"))
 *             .build());
 *         var exampleDestinationBucketV2 = new BucketV2("exampleDestinationBucketV2");
 *         final var exampleDestinationPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("AllowAppFlowDestinationActions")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("appflow.amazonaws.com")
 *                     .build())
 *                 .actions(
 *                     "s3:PutObject",
 *                     "s3:AbortMultipartUpload",
 *                     "s3:ListMultipartUploadParts",
 *                     "s3:ListBucketMultipartUploads",
 *                     "s3:GetBucketAcl",
 *                     "s3:PutObjectAcl")
 *                 .resources(
 *                     "arn:aws:s3:::example-destination",
 *                     "arn:aws:s3:::example-destination/*")
 *                 .build())
 *             .build());
 *         var exampleDestinationBucketPolicy = new BucketPolicy("exampleDestinationBucketPolicy", BucketPolicyArgs.builder()
 *             .bucket(exampleDestinationBucketV2.id())
 *             .policy(exampleDestinationPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleFlow = new Flow("exampleFlow", FlowArgs.builder()
 *             .sourceFlowConfig(FlowSourceFlowConfigArgs.builder()
 *                 .connectorType("S3")
 *                 .sourceConnectorProperties(FlowSourceFlowConfigSourceConnectorPropertiesArgs.builder()
 *                     .s3(FlowSourceFlowConfigSourceConnectorPropertiesS3Args.builder()
 *                         .bucketName(exampleSourceBucketPolicy.bucket())
 *                         .bucketPrefix("example")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .destinationFlowConfigs(FlowDestinationFlowConfigArgs.builder()
 *                 .connectorType("S3")
 *                 .destinationConnectorProperties(FlowDestinationFlowConfigDestinationConnectorPropertiesArgs.builder()
 *                     .s3(FlowDestinationFlowConfigDestinationConnectorPropertiesS3Args.builder()
 *                         .bucketName(exampleDestinationBucketPolicy.bucket())
 *                         .s3OutputFormatConfig(FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigArgs.builder()
 *                             .prefixConfig(FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigPrefixConfigArgs.builder()
 *                                 .prefixType("PATH")
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .tasks(FlowTaskArgs.builder()
 *                 .sourceFields("exampleField")
 *                 .destinationField("exampleField")
 *                 .taskType("Map")
 *                 .connectorOperators(FlowTaskConnectorOperatorArgs.builder()
 *                     .s3("NO_OP")
 *                     .build())
 *                 .build())
 *             .triggerConfig(FlowTriggerConfigArgs.builder()
 *                 .triggerType("OnDemand")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AppFlow flows using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:appflow/flow:Flow example arn:aws:appflow:us-west-2:123456789012:flow/example-flow
 * ```
 * @property description Description of the flow you want to create.
 * @property destinationFlowConfigs A Destination Flow Config that controls how Amazon AppFlow places data in the destination connector.
 * @property kmsArn ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
 * @property name Name of the flow.
 * @property sourceFlowConfig The Source Flow Config that controls how Amazon AppFlow retrieves data from the source connector.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property tasks A Task that Amazon AppFlow performs while transferring the data in the flow run.
 * @property triggerConfig A Trigger that determine how and when the flow runs.
 * */*/
 */
public data class FlowArgs(
    public val description: Output<String>? = null,
    public val destinationFlowConfigs: Output<List<FlowDestinationFlowConfigArgs>>? = null,
    public val kmsArn: Output<String>? = null,
    public val name: Output<String>? = null,
    public val sourceFlowConfig: Output<FlowSourceFlowConfigArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tasks: Output<List<FlowTaskArgs>>? = null,
    public val triggerConfig: Output<FlowTriggerConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appflow.FlowArgs> {
    override fun toJava(): com.pulumi.aws.appflow.FlowArgs = com.pulumi.aws.appflow.FlowArgs.builder()
        .description(description?.applyValue({ args0 -> args0 }))
        .destinationFlowConfigs(
            destinationFlowConfigs?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .kmsArn(kmsArn?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .sourceFlowConfig(sourceFlowConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .tasks(tasks?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
        .triggerConfig(triggerConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FlowArgs].
 */
@PulumiTagMarker
public class FlowArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var destinationFlowConfigs: Output<List<FlowDestinationFlowConfigArgs>>? = null

    private var kmsArn: Output<String>? = null

    private var name: Output<String>? = null

    private var sourceFlowConfig: Output<FlowSourceFlowConfigArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tasks: Output<List<FlowTaskArgs>>? = null

    private var triggerConfig: Output<FlowTriggerConfigArgs>? = null

    /**
     * @param value Description of the flow you want to create.
     */
    @JvmName("qoeyumceptdyrovn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A Destination Flow Config that controls how Amazon AppFlow places data in the destination connector.
     */
    @JvmName("mxgmcqjkssftxtqb")
    public suspend fun destinationFlowConfigs(`value`: Output<List<FlowDestinationFlowConfigArgs>>) {
        this.destinationFlowConfigs = value
    }

    @JvmName("kkqxtbadlxdnpawg")
    public suspend fun destinationFlowConfigs(vararg values: Output<FlowDestinationFlowConfigArgs>) {
        this.destinationFlowConfigs = Output.all(values.asList())
    }

    /**
     * @param values A Destination Flow Config that controls how Amazon AppFlow places data in the destination connector.
     */
    @JvmName("nrxkdcajebnfqqdu")
    public suspend fun destinationFlowConfigs(values: List<Output<FlowDestinationFlowConfigArgs>>) {
        this.destinationFlowConfigs = Output.all(values)
    }

    /**
     * @param value ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
     */
    @JvmName("tpnjfjsxefqnjwng")
    public suspend fun kmsArn(`value`: Output<String>) {
        this.kmsArn = value
    }

    /**
     * @param value Name of the flow.
     */
    @JvmName("rakmrdlhgvexudlj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Source Flow Config that controls how Amazon AppFlow retrieves data from the source connector.
     */
    @JvmName("tgcsawigiiqtdmgm")
    public suspend fun sourceFlowConfig(`value`: Output<FlowSourceFlowConfigArgs>) {
        this.sourceFlowConfig = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fyaaktssfptkcdjt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A Task that Amazon AppFlow performs while transferring the data in the flow run.
     */
    @JvmName("hweyvhsgedbvyxix")
    public suspend fun tasks(`value`: Output<List<FlowTaskArgs>>) {
        this.tasks = value
    }

    @JvmName("fivjcnmlbcdqsrih")
    public suspend fun tasks(vararg values: Output<FlowTaskArgs>) {
        this.tasks = Output.all(values.asList())
    }

    /**
     * @param values A Task that Amazon AppFlow performs while transferring the data in the flow run.
     */
    @JvmName("dgdhwjubweclsotf")
    public suspend fun tasks(values: List<Output<FlowTaskArgs>>) {
        this.tasks = Output.all(values)
    }

    /**
     * @param value A Trigger that determine how and when the flow runs.
     */
    @JvmName("jjxcnmtotmojugtv")
    public suspend fun triggerConfig(`value`: Output<FlowTriggerConfigArgs>) {
        this.triggerConfig = value
    }

    /**
     * @param value Description of the flow you want to create.
     */
    @JvmName("ajiqggbquliweago")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A Destination Flow Config that controls how Amazon AppFlow places data in the destination connector.
     */
    @JvmName("orteumokhskbapby")
    public suspend fun destinationFlowConfigs(`value`: List<FlowDestinationFlowConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationFlowConfigs = mapped
    }

    /**
     * @param argument A Destination Flow Config that controls how Amazon AppFlow places data in the destination connector.
     */
    @JvmName("obbahfpetalwawyu")
    public suspend
    fun destinationFlowConfigs(argument: List<suspend FlowDestinationFlowConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FlowDestinationFlowConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationFlowConfigs = mapped
    }

    /**
     * @param argument A Destination Flow Config that controls how Amazon AppFlow places data in the destination connector.
     */
    @JvmName("tmbdhjsimrssgmnb")
    public suspend fun destinationFlowConfigs(
        vararg
        argument: suspend FlowDestinationFlowConfigArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FlowDestinationFlowConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationFlowConfigs = mapped
    }

    /**
     * @param argument A Destination Flow Config that controls how Amazon AppFlow places data in the destination connector.
     */
    @JvmName("lpasxclxoaealbrc")
    public suspend
    fun destinationFlowConfigs(argument: suspend FlowDestinationFlowConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FlowDestinationFlowConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.destinationFlowConfigs = mapped
    }

    /**
     * @param values A Destination Flow Config that controls how Amazon AppFlow places data in the destination connector.
     */
    @JvmName("ceulbapunsionvxv")
    public suspend fun destinationFlowConfigs(vararg values: FlowDestinationFlowConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationFlowConfigs = mapped
    }

    /**
     * @param value ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
     */
    @JvmName("gmfqtccidcomotxv")
    public suspend fun kmsArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsArn = mapped
    }

    /**
     * @param value Name of the flow.
     */
    @JvmName("iwohbwfyhmbkgiej")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Source Flow Config that controls how Amazon AppFlow retrieves data from the source connector.
     */
    @JvmName("qhkqndlsdawoqhgf")
    public suspend fun sourceFlowConfig(`value`: FlowSourceFlowConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceFlowConfig = mapped
    }

    /**
     * @param argument The Source Flow Config that controls how Amazon AppFlow retrieves data from the source connector.
     */
    @JvmName("mfpstuyooitppibl")
    public suspend
    fun sourceFlowConfig(argument: suspend FlowSourceFlowConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FlowSourceFlowConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceFlowConfig = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("efijeagpdqnlfnuu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ksvwfbviqmjascct")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A Task that Amazon AppFlow performs while transferring the data in the flow run.
     */
    @JvmName("ckpiknmbqjspvxfs")
    public suspend fun tasks(`value`: List<FlowTaskArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tasks = mapped
    }

    /**
     * @param argument A Task that Amazon AppFlow performs while transferring the data in the flow run.
     */
    @JvmName("orhfiqpmtovbaglf")
    public suspend fun tasks(argument: List<suspend FlowTaskArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { FlowTaskArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.tasks = mapped
    }

    /**
     * @param argument A Task that Amazon AppFlow performs while transferring the data in the flow run.
     */
    @JvmName("xcqskxnvsduppgva")
    public suspend fun tasks(vararg argument: suspend FlowTaskArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { FlowTaskArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.tasks = mapped
    }

    /**
     * @param argument A Task that Amazon AppFlow performs while transferring the data in the flow run.
     */
    @JvmName("qmfubhbocyhlummb")
    public suspend fun tasks(argument: suspend FlowTaskArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FlowTaskArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.tasks = mapped
    }

    /**
     * @param values A Task that Amazon AppFlow performs while transferring the data in the flow run.
     */
    @JvmName("ublumornjxdhqgka")
    public suspend fun tasks(vararg values: FlowTaskArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tasks = mapped
    }

    /**
     * @param value A Trigger that determine how and when the flow runs.
     */
    @JvmName("wvalsuutjujjpmsj")
    public suspend fun triggerConfig(`value`: FlowTriggerConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggerConfig = mapped
    }

    /**
     * @param argument A Trigger that determine how and when the flow runs.
     */
    @JvmName("ayqgcejfsycjgfao")
    public suspend fun triggerConfig(argument: suspend FlowTriggerConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FlowTriggerConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.triggerConfig = mapped
    }

    internal fun build(): FlowArgs = FlowArgs(
        description = description,
        destinationFlowConfigs = destinationFlowConfigs,
        kmsArn = kmsArn,
        name = name,
        sourceFlowConfig = sourceFlowConfig,
        tags = tags,
        tasks = tasks,
        triggerConfig = triggerConfig,
    )
}
