@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsAmplitudeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiKey Unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
 * @property secretKey The Secret Access Key portion of the credentials.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsAmplitudeArgs(
    public val apiKey: Output<String>,
    public val secretKey: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsAmplitudeArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsAmplitudeArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsAmplitudeArgs.builder()
            .apiKey(apiKey.applyValue({ args0 -> args0 }))
            .secretKey(secretKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsAmplitudeArgs].
 */
@PulumiTagMarker
public class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsAmplitudeArgsBuilder
internal constructor() {
    private var apiKey: Output<String>? = null

    private var secretKey: Output<String>? = null

    /**
     * @param value Unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
     */
    @JvmName("lggyvudajlsfrkrw")
    public suspend fun apiKey(`value`: Output<String>) {
        this.apiKey = value
    }

    /**
     * @param value The Secret Access Key portion of the credentials.
     */
    @JvmName("rduvesvtymvcxrlk")
    public suspend fun secretKey(`value`: Output<String>) {
        this.secretKey = value
    }

    /**
     * @param value Unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
     */
    @JvmName("qbiuqdfembldogpt")
    public suspend fun apiKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiKey = mapped
    }

    /**
     * @param value The Secret Access Key portion of the credentials.
     */
    @JvmName("wuvxkenooaxgbvrh")
    public suspend fun secretKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretKey = mapped
    }

    internal fun build():
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsAmplitudeArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsAmplitudeArgs(
            apiKey = apiKey ?: throw PulumiNullFieldException("apiKey"),
            secretKey = secretKey ?: throw PulumiNullFieldException("secretKey"),
        )
}
