@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorApiKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiKey Unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
 * @property apiSecretKey The API secret key required for API key authentication.
 */
public data class
ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorApiKeyArgs(
    public val apiKey: Output<String>,
    public val apiSecretKey: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorApiKeyArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorApiKeyArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorApiKeyArgs.builder()
            .apiKey(apiKey.applyValue({ args0 -> args0 }))
            .apiSecretKey(apiSecretKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorApiKeyArgs].
 */
@PulumiTagMarker
public class
ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorApiKeyArgsBuilder
internal constructor() {
    private var apiKey: Output<String>? = null

    private var apiSecretKey: Output<String>? = null

    /**
     * @param value Unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
     */
    @JvmName("bnrigrkuocbwhglh")
    public suspend fun apiKey(`value`: Output<String>) {
        this.apiKey = value
    }

    /**
     * @param value The API secret key required for API key authentication.
     */
    @JvmName("jwbeovqttacbjgfy")
    public suspend fun apiSecretKey(`value`: Output<String>) {
        this.apiSecretKey = value
    }

    /**
     * @param value Unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
     */
    @JvmName("beryoynfmmpwxsfb")
    public suspend fun apiKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiKey = mapped
    }

    /**
     * @param value The API secret key required for API key authentication.
     */
    @JvmName("uufortsdjsbgwjdg")
    public suspend fun apiSecretKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiSecretKey = mapped
    }

    internal fun build():
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorApiKeyArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorApiKeyArgs(
            apiKey = apiKey ?: throw PulumiNullFieldException("apiKey"),
            apiSecretKey = apiSecretKey,
        )
}
