@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorCustomArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property credentialsMap A map that holds custom authentication credentials.
 * @property customAuthenticationType The custom authentication type that the connector uses.
 */
public data class
ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorCustomArgs(
    public val credentialsMap: Output<Map<String, String>>? = null,
    public val customAuthenticationType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorCustomArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorCustomArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorCustomArgs.builder()
            .credentialsMap(
                credentialsMap?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .customAuthenticationType(customAuthenticationType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorCustomArgs].
 */
@PulumiTagMarker
public class
ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorCustomArgsBuilder
internal constructor() {
    private var credentialsMap: Output<Map<String, String>>? = null

    private var customAuthenticationType: Output<String>? = null

    /**
     * @param value A map that holds custom authentication credentials.
     */
    @JvmName("wfiqrwnrbctpeahe")
    public suspend fun credentialsMap(`value`: Output<Map<String, String>>) {
        this.credentialsMap = value
    }

    /**
     * @param value The custom authentication type that the connector uses.
     */
    @JvmName("cfbjalssruvrhjcq")
    public suspend fun customAuthenticationType(`value`: Output<String>) {
        this.customAuthenticationType = value
    }

    /**
     * @param value A map that holds custom authentication credentials.
     */
    @JvmName("hotbxaundaqbxuwp")
    public suspend fun credentialsMap(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentialsMap = mapped
    }

    /**
     * @param values A map that holds custom authentication credentials.
     */
    @JvmName("licrbbesxcboyleq")
    public fun credentialsMap(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentialsMap = mapped
    }

    /**
     * @param value The custom authentication type that the connector uses.
     */
    @JvmName("gibuexsqtnuyotqo")
    public suspend fun customAuthenticationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customAuthenticationType = mapped
    }

    internal fun build():
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorCustomArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorCustomArgs(
            credentialsMap = credentialsMap,
            customAuthenticationType = customAuthenticationType ?: throw
                PulumiNullFieldException("customAuthenticationType"),
        )
}
