@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDynatraceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiToken The API tokens used by Dynatrace API to authenticate various API calls.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDynatraceArgs(
    public val apiToken: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDynatraceArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDynatraceArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDynatraceArgs.builder()
            .apiToken(apiToken.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDynatraceArgs].
 */
@PulumiTagMarker
public class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDynatraceArgsBuilder
internal constructor() {
    private var apiToken: Output<String>? = null

    /**
     * @param value The API tokens used by Dynatrace API to authenticate various API calls.
     */
    @JvmName("lbfddtubfislppfr")
    public suspend fun apiToken(`value`: Output<String>) {
        this.apiToken = value
    }

    /**
     * @param value The API tokens used by Dynatrace API to authenticate various API calls.
     */
    @JvmName("rdugtoieheuslaum")
    public suspend fun apiToken(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiToken = mapped
    }

    internal fun build():
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDynatraceArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDynatraceArgs(
            apiToken = apiToken ?: throw PulumiNullFieldException("apiToken"),
        )
}
