@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycodeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property accessToken The access token used to access the connector on your behalf.
 * @property oauthRequest Used by select connectors for which the OAuth workflow is supported. See OAuth Request for more details.
 * @property refreshToken The refresh token used to refresh an expired access token.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycodeArgs(
    public val accessToken: Output<String>? = null,
    public val oauthRequest:
    Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycodeOauthRequestArgs>? =
        null,
    public val refreshToken: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycodeArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycodeArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycodeArgs.builder()
            .accessToken(accessToken?.applyValue({ args0 -> args0 }))
            .oauthRequest(oauthRequest?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .refreshToken(refreshToken?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycodeArgs].
 */
@PulumiTagMarker
public class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycodeArgsBuilder
internal constructor() {
    private var accessToken: Output<String>? = null

    private var oauthRequest:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycodeOauthRequestArgs>? =
        null

    private var refreshToken: Output<String>? = null

    /**
     * @param value The access token used to access the connector on your behalf.
     */
    @JvmName("dvhjfdrhceqmetty")
    public suspend fun accessToken(`value`: Output<String>) {
        this.accessToken = value
    }

    /**
     * @param value Used by select connectors for which the OAuth workflow is supported. See OAuth Request for more details.
     */
    @JvmName("clumbqwxoyxeiats")
    public suspend
    fun oauthRequest(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycodeOauthRequestArgs>) {
        this.oauthRequest = value
    }

    /**
     * @param value The refresh token used to refresh an expired access token.
     */
    @JvmName("hovircyvfrpjfigd")
    public suspend fun refreshToken(`value`: Output<String>) {
        this.refreshToken = value
    }

    /**
     * @param value The access token used to access the connector on your behalf.
     */
    @JvmName("yykkopqbkcsqrkwg")
    public suspend fun accessToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value Used by select connectors for which the OAuth workflow is supported. See OAuth Request for more details.
     */
    @JvmName("bhgmhjxfixthspcj")
    public suspend
    fun oauthRequest(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycodeOauthRequestArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oauthRequest = mapped
    }

    /**
     * @param argument Used by select connectors for which the OAuth workflow is supported. See OAuth Request for more details.
     */
    @JvmName("rgoyrxoreyllwmli")
    public suspend
    fun oauthRequest(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycodeOauthRequestArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycodeOauthRequestArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.oauthRequest = mapped
    }

    /**
     * @param value The refresh token used to refresh an expired access token.
     */
    @JvmName("dnqhakdbsjucebfx")
    public suspend fun refreshToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshToken = mapped
    }

    internal fun build():
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycodeArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycodeArgs(
            accessToken = accessToken,
            oauthRequest = oauthRequest,
            refreshToken = refreshToken,
        )
}
