@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsInforNexusArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessKeyId The Access Key portion of the credentials.
 * @property datakey Encryption keys used to encrypt data.
 * @property secretAccessKey The secret key used to sign requests.
 * @property userId Identifier for the user.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsInforNexusArgs(
    public val accessKeyId: Output<String>,
    public val datakey: Output<String>,
    public val secretAccessKey: Output<String>,
    public val userId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsInforNexusArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsInforNexusArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsInforNexusArgs.builder()
            .accessKeyId(accessKeyId.applyValue({ args0 -> args0 }))
            .datakey(datakey.applyValue({ args0 -> args0 }))
            .secretAccessKey(secretAccessKey.applyValue({ args0 -> args0 }))
            .userId(userId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsInforNexusArgs].
 */
@PulumiTagMarker
public class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsInforNexusArgsBuilder
internal constructor() {
    private var accessKeyId: Output<String>? = null

    private var datakey: Output<String>? = null

    private var secretAccessKey: Output<String>? = null

    private var userId: Output<String>? = null

    /**
     * @param value The Access Key portion of the credentials.
     */
    @JvmName("gcklgdhndorqsmsh")
    public suspend fun accessKeyId(`value`: Output<String>) {
        this.accessKeyId = value
    }

    /**
     * @param value Encryption keys used to encrypt data.
     */
    @JvmName("whiullthbsqjytrk")
    public suspend fun datakey(`value`: Output<String>) {
        this.datakey = value
    }

    /**
     * @param value The secret key used to sign requests.
     */
    @JvmName("ccodjolaxbsqlcwv")
    public suspend fun secretAccessKey(`value`: Output<String>) {
        this.secretAccessKey = value
    }

    /**
     * @param value Identifier for the user.
     */
    @JvmName("xqpsjmbvobxbyvlk")
    public suspend fun userId(`value`: Output<String>) {
        this.userId = value
    }

    /**
     * @param value The Access Key portion of the credentials.
     */
    @JvmName("irkunjoeqpqmtbmh")
    public suspend fun accessKeyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessKeyId = mapped
    }

    /**
     * @param value Encryption keys used to encrypt data.
     */
    @JvmName("dxlhspwsjjcurmnn")
    public suspend fun datakey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.datakey = mapped
    }

    /**
     * @param value The secret key used to sign requests.
     */
    @JvmName("bynqpchcxkfdybtj")
    public suspend fun secretAccessKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretAccessKey = mapped
    }

    /**
     * @param value Identifier for the user.
     */
    @JvmName("gpgojnpitcopnnba")
    public suspend fun userId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    internal fun build():
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsInforNexusArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsInforNexusArgs(
            accessKeyId = accessKeyId ?: throw PulumiNullFieldException("accessKeyId"),
            datakey = datakey ?: throw PulumiNullFieldException("datakey"),
            secretAccessKey = secretAccessKey ?: throw PulumiNullFieldException("secretAccessKey"),
            userId = userId ?: throw PulumiNullFieldException("userId"),
        )
}
