@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoOauthRequestArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authCode The code provided by the connector when it has been authenticated via the connected app.
 * @property redirectUri The URL to which the authentication server redirects the browser after authorization has been granted.
 */
public data class
ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoOauthRequestArgs(
    public val authCode: Output<String>? = null,
    public val redirectUri: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoOauthRequestArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoOauthRequestArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoOauthRequestArgs.builder()
            .authCode(authCode?.applyValue({ args0 -> args0 }))
            .redirectUri(redirectUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoOauthRequestArgs].
 */
@PulumiTagMarker
public class
ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoOauthRequestArgsBuilder
internal constructor() {
    private var authCode: Output<String>? = null

    private var redirectUri: Output<String>? = null

    /**
     * @param value The code provided by the connector when it has been authenticated via the connected app.
     */
    @JvmName("bllfndswstbxerax")
    public suspend fun authCode(`value`: Output<String>) {
        this.authCode = value
    }

    /**
     * @param value The URL to which the authentication server redirects the browser after authorization has been granted.
     */
    @JvmName("pjhkpcgibhhqsiew")
    public suspend fun redirectUri(`value`: Output<String>) {
        this.redirectUri = value
    }

    /**
     * @param value The code provided by the connector when it has been authenticated via the connected app.
     */
    @JvmName("nnhyqcvglqqfnkol")
    public suspend fun authCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authCode = mapped
    }

    /**
     * @param value The URL to which the authentication server redirects the browser after authorization has been granted.
     */
    @JvmName("nyxnymiqnimkqyyt")
    public suspend fun redirectUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirectUri = mapped
    }

    internal fun build():
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoOauthRequestArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoOauthRequestArgs(
            authCode = authCode,
            redirectUri = redirectUri,
        )
}
