@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property accessToken The access token used to access the connector on your behalf.
 * @property clientCredentialsArn The secret manager ARN, which contains the client ID and client secret of the connected app.
 * @property jwtToken A JSON web token (JWT) that authorizes access to Salesforce records.
 * @property oauth2GrantType The OAuth 2.0 grant type used by connector for OAuth 2.0 authentication. One of: `AUTHORIZATION_CODE`, `CLIENT_CREDENTIALS`.
 * @property oauthRequest Used by select connectors for which the OAuth workflow is supported. See OAuth Request for more details.
 * @property refreshToken The refresh token used to refresh an expired access token.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgs(
    public val accessToken: Output<String>? = null,
    public val clientCredentialsArn: Output<String>? = null,
    public val jwtToken: Output<String>? = null,
    public val oauth2GrantType: Output<String>? = null,
    public val oauthRequest:
    Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceOauthRequestArgs>? =
        null,
    public val refreshToken: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgs.builder()
            .accessToken(accessToken?.applyValue({ args0 -> args0 }))
            .clientCredentialsArn(clientCredentialsArn?.applyValue({ args0 -> args0 }))
            .jwtToken(jwtToken?.applyValue({ args0 -> args0 }))
            .oauth2GrantType(oauth2GrantType?.applyValue({ args0 -> args0 }))
            .oauthRequest(oauthRequest?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .refreshToken(refreshToken?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgs].
 */
@PulumiTagMarker
public class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgsBuilder
internal constructor() {
    private var accessToken: Output<String>? = null

    private var clientCredentialsArn: Output<String>? = null

    private var jwtToken: Output<String>? = null

    private var oauth2GrantType: Output<String>? = null

    private var oauthRequest:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceOauthRequestArgs>? =
        null

    private var refreshToken: Output<String>? = null

    /**
     * @param value The access token used to access the connector on your behalf.
     */
    @JvmName("mvkfjumnftbaohmj")
    public suspend fun accessToken(`value`: Output<String>) {
        this.accessToken = value
    }

    /**
     * @param value The secret manager ARN, which contains the client ID and client secret of the connected app.
     */
    @JvmName("tlaxwsybvfgxxbxb")
    public suspend fun clientCredentialsArn(`value`: Output<String>) {
        this.clientCredentialsArn = value
    }

    /**
     * @param value A JSON web token (JWT) that authorizes access to Salesforce records.
     */
    @JvmName("trvvintvingvkafr")
    public suspend fun jwtToken(`value`: Output<String>) {
        this.jwtToken = value
    }

    /**
     * @param value The OAuth 2.0 grant type used by connector for OAuth 2.0 authentication. One of: `AUTHORIZATION_CODE`, `CLIENT_CREDENTIALS`.
     */
    @JvmName("ebpqhdnnwelyodta")
    public suspend fun oauth2GrantType(`value`: Output<String>) {
        this.oauth2GrantType = value
    }

    /**
     * @param value Used by select connectors for which the OAuth workflow is supported. See OAuth Request for more details.
     */
    @JvmName("hdgdreofnaknecmw")
    public suspend
    fun oauthRequest(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceOauthRequestArgs>) {
        this.oauthRequest = value
    }

    /**
     * @param value The refresh token used to refresh an expired access token.
     */
    @JvmName("khlbrdgihpliouhc")
    public suspend fun refreshToken(`value`: Output<String>) {
        this.refreshToken = value
    }

    /**
     * @param value The access token used to access the connector on your behalf.
     */
    @JvmName("iqvchanvnjubkblc")
    public suspend fun accessToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value The secret manager ARN, which contains the client ID and client secret of the connected app.
     */
    @JvmName("cwypptbxyeclixva")
    public suspend fun clientCredentialsArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCredentialsArn = mapped
    }

    /**
     * @param value A JSON web token (JWT) that authorizes access to Salesforce records.
     */
    @JvmName("efaiyxbttbplismi")
    public suspend fun jwtToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jwtToken = mapped
    }

    /**
     * @param value The OAuth 2.0 grant type used by connector for OAuth 2.0 authentication. One of: `AUTHORIZATION_CODE`, `CLIENT_CREDENTIALS`.
     */
    @JvmName("emvbcyityayfdgqp")
    public suspend fun oauth2GrantType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oauth2GrantType = mapped
    }

    /**
     * @param value Used by select connectors for which the OAuth workflow is supported. See OAuth Request for more details.
     */
    @JvmName("qgxsrfusqqdcdrhe")
    public suspend
    fun oauthRequest(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceOauthRequestArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oauthRequest = mapped
    }

    /**
     * @param argument Used by select connectors for which the OAuth workflow is supported. See OAuth Request for more details.
     */
    @JvmName("ddywnvwchxyxyfdb")
    public suspend
    fun oauthRequest(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceOauthRequestArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceOauthRequestArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.oauthRequest = mapped
    }

    /**
     * @param value The refresh token used to refresh an expired access token.
     */
    @JvmName("ytfycfqjgdomkbrw")
    public suspend fun refreshToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshToken = mapped
    }

    internal fun build():
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgs(
            accessToken = accessToken,
            clientCredentialsArn = clientCredentialsArn,
            jwtToken = jwtToken,
            oauth2GrantType = oauth2GrantType,
            oauthRequest = oauthRequest,
            refreshToken = refreshToken,
        )
}
