@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property basicAuthCredentials The SAPOData basic authentication credentials.
 * @property oauthCredentials The SAPOData OAuth type authentication credentials.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataArgs(
    public val basicAuthCredentials:
    Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataBasicAuthCredentialsArgs>? =
        null,
    public val oauthCredentials:
    Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataArgs.builder()
            .basicAuthCredentials(
                basicAuthCredentials?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .oauthCredentials(
                oauthCredentials?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataArgs].
 */
@PulumiTagMarker
public class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataArgsBuilder
internal constructor() {
    private var basicAuthCredentials:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataBasicAuthCredentialsArgs>? =
        null

    private var oauthCredentials:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsArgs>? =
        null

    /**
     * @param value The SAPOData basic authentication credentials.
     */
    @JvmName("vmnwtmaejybcqqic")
    public suspend
    fun basicAuthCredentials(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataBasicAuthCredentialsArgs>) {
        this.basicAuthCredentials = value
    }

    /**
     * @param value The SAPOData OAuth type authentication credentials.
     */
    @JvmName("hnhrnajwojdxpnqq")
    public suspend
    fun oauthCredentials(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsArgs>) {
        this.oauthCredentials = value
    }

    /**
     * @param value The SAPOData basic authentication credentials.
     */
    @JvmName("pwwqucybkubqbfnd")
    public suspend
    fun basicAuthCredentials(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataBasicAuthCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basicAuthCredentials = mapped
    }

    /**
     * @param argument The SAPOData basic authentication credentials.
     */
    @JvmName("fdwmqilbfsrthcuf")
    public suspend
    fun basicAuthCredentials(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataBasicAuthCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataBasicAuthCredentialsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.basicAuthCredentials = mapped
    }

    /**
     * @param value The SAPOData OAuth type authentication credentials.
     */
    @JvmName("xjjssglepkpeaefs")
    public suspend
    fun oauthCredentials(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oauthCredentials = mapped
    }

    /**
     * @param argument The SAPOData OAuth type authentication credentials.
     */
    @JvmName("uytbbifikwdjjaef")
    public suspend
    fun oauthCredentials(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.oauthCredentials = mapped
    }

    internal fun build():
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataArgs(
            basicAuthCredentials = basicAuthCredentials,
            oauthCredentials = oauthCredentials,
        )
}
