@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataBasicAuthCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property password The password to use to connect to a resource.
 * @property username The username to use to connect to a resource.
 */
public data class
ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataBasicAuthCredentialsArgs(
    public val password: Output<String>,
    public val username: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataBasicAuthCredentialsArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataBasicAuthCredentialsArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataBasicAuthCredentialsArgs.builder()
            .password(password.applyValue({ args0 -> args0 }))
            .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataBasicAuthCredentialsArgs].
 */
@PulumiTagMarker
public class
ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataBasicAuthCredentialsArgsBuilder
internal constructor() {
    private var password: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The password to use to connect to a resource.
     */
    @JvmName("hvbromrypwjldxjl")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The username to use to connect to a resource.
     */
    @JvmName("tajtrgrdtivvcetd")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The password to use to connect to a resource.
     */
    @JvmName("meyngcnyfibqqxjs")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The username to use to connect to a resource.
     */
    @JvmName("btdisfvtkojauqfp")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build():
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataBasicAuthCredentialsArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataBasicAuthCredentialsArgs(
            password = password ?: throw PulumiNullFieldException("password"),
            username = username ?: throw PulumiNullFieldException("username"),
        )
}
