@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property accessToken The access token used to access the connector on your behalf.
 * @property clientId The identifier for the desired client.
 * @property clientSecret The client secret used by the OAuth client to authenticate to the authorization server.
 * @property oauthRequest Used by select connectors for which the OAuth workflow is supported. See OAuth Request for more details.
 * @property refreshToken The refresh token used to refresh an expired access token.
 */
public data class
ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsArgs(
    public val accessToken: Output<String>? = null,
    public val clientId: Output<String>,
    public val clientSecret: Output<String>,
    public val oauthRequest:
    Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsOauthRequestArgs>? =
        null,
    public val refreshToken: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsArgs> {
    override fun toJava():
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsArgs.builder()
            .accessToken(accessToken?.applyValue({ args0 -> args0 }))
            .clientId(clientId.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret.applyValue({ args0 -> args0 }))
            .oauthRequest(oauthRequest?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .refreshToken(refreshToken?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsArgs].
 */
@PulumiTagMarker
public class
ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsArgsBuilder
internal constructor() {
    private var accessToken: Output<String>? = null

    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var oauthRequest:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsOauthRequestArgs>? =
        null

    private var refreshToken: Output<String>? = null

    /**
     * @param value The access token used to access the connector on your behalf.
     */
    @JvmName("yamlfmqntrokismg")
    public suspend fun accessToken(`value`: Output<String>) {
        this.accessToken = value
    }

    /**
     * @param value The identifier for the desired client.
     */
    @JvmName("qbgrfynrqdcrlxrj")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The client secret used by the OAuth client to authenticate to the authorization server.
     */
    @JvmName("dohefbimiibnbscw")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value Used by select connectors for which the OAuth workflow is supported. See OAuth Request for more details.
     */
    @JvmName("fogcxgnwqpqdwate")
    public suspend
    fun oauthRequest(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsOauthRequestArgs>) {
        this.oauthRequest = value
    }

    /**
     * @param value The refresh token used to refresh an expired access token.
     */
    @JvmName("gbgwewkphpyanpjo")
    public suspend fun refreshToken(`value`: Output<String>) {
        this.refreshToken = value
    }

    /**
     * @param value The access token used to access the connector on your behalf.
     */
    @JvmName("gtafwqijlosjcrql")
    public suspend fun accessToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value The identifier for the desired client.
     */
    @JvmName("sludqaioquoutwkk")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The client secret used by the OAuth client to authenticate to the authorization server.
     */
    @JvmName("idyisdyrixekmlsj")
    public suspend fun clientSecret(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value Used by select connectors for which the OAuth workflow is supported. See OAuth Request for more details.
     */
    @JvmName("cgfmjeumvfvladxe")
    public suspend
    fun oauthRequest(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsOauthRequestArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oauthRequest = mapped
    }

    /**
     * @param argument Used by select connectors for which the OAuth workflow is supported. See OAuth Request for more details.
     */
    @JvmName("dbsgdvtdvasdndgi")
    public suspend
    fun oauthRequest(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsOauthRequestArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsOauthRequestArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.oauthRequest = mapped
    }

    /**
     * @param value The refresh token used to refresh an expired access token.
     */
    @JvmName("vvuupotdgfretudr")
    public suspend fun refreshToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshToken = mapped
    }

    internal fun build():
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataOauthCredentialsArgs(
            accessToken = accessToken,
            clientId = clientId ?: throw PulumiNullFieldException("clientId"),
            clientSecret = clientSecret ?: throw PulumiNullFieldException("clientSecret"),
            oauthRequest = oauthRequest,
            refreshToken = refreshToken,
        )
}
